/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.common.service;

import io.jans.as.model.config.StaticConfiguration;
import io.jans.model.JansAttribute;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.search.filter.Filter;
import io.jans.service.BaseCacheService;
import io.jans.util.StringHelper;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;

public abstract class AttributeService
extends io.jans.service.AttributeService {
    private static final long serialVersionUID = -990409035168814270L;
    @Inject
    private Logger logger;
    @Inject
    private StaticConfiguration staticConfiguration;

    public JansAttribute getAttributeByDn(String dn) {
        BaseCacheService usedCacheService = this.getCacheService();
        return (JansAttribute)usedCacheService.getWithPut(dn, () -> (JansAttribute)this.persistenceEntryManager.find(JansAttribute.class, (Object)dn), 60);
    }

    public JansAttribute getByLdapName(String name) {
        BaseCacheService usedCacheService = this.getCacheService();
        return (JansAttribute)usedCacheService.getWithPut("adn_" + name, () -> {
            List jansAttributes = this.getAttributesByAttribute("jansAttrName", name, this.staticConfiguration.getBaseDn().getAttributes());
            if (jansAttributes.size() > 0) {
                for (JansAttribute jansAttribute : jansAttributes) {
                    if (jansAttribute.getName() == null || !jansAttribute.getName().equals(name)) continue;
                    return jansAttribute;
                }
            }
            return null;
        }, 30);
    }

    public JansAttribute getByClaimName(String name) {
        BaseCacheService usedCacheService = this.getCacheService();
        return (JansAttribute)usedCacheService.getWithPut("acn_" + name, () -> {
            List jansAttributes = this.getAttributesByAttribute("jansClaimName", name, this.staticConfiguration.getBaseDn().getAttributes());
            if (jansAttributes.size() > 0) {
                for (JansAttribute jansAttribute : jansAttributes) {
                    if (jansAttribute.getClaimName() == null || !jansAttribute.getClaimName().equals(name)) continue;
                    return jansAttribute;
                }
            }
            return null;
        }, 30);
    }

    public String generateInumForNewAttribute() {
        String newInum = null;
        String newDn = null;
        while (this.containsAttribute(newDn = this.getDnForAttribute(newInum = UUID.randomUUID().toString()))) {
        }
        return newInum;
    }

    public boolean containsAttribute(String dn) {
        return this.persistenceEntryManager.contains(dn, JansAttribute.class);
    }

    public List<JansAttribute> getAllAttributes() {
        return this.getAllAttributes(this.staticConfiguration.getBaseDn().getAttributes());
    }

    public String getDnForAttribute(String inum) {
        String attributesDn = this.staticConfiguration.getBaseDn().getAttributes();
        if (StringHelper.isEmpty((String)inum)) {
            return attributesDn;
        }
        return String.format("inum=%s,%s", inum, attributesDn);
    }

    public List<String> getAttributesDn(List<String> claimNames) {
        ArrayList<String> claims = new ArrayList<String>();
        for (String claimName : claimNames) {
            JansAttribute jansAttribute = this.getByClaimName(claimName);
            if (jansAttribute == null) continue;
            claims.add(jansAttribute.getDn());
        }
        return claims;
    }

    protected BaseCacheService getCacheService() {
        if (this.isUseLocalCache()) {
            return this.localCacheService;
        }
        return this.cacheService;
    }

    public List<JansAttribute> searchAttributes(String pattern, int sizeLimit) throws Exception {
        Filter searchFilter;
        boolean useLowercaseFilter;
        String baseDn = this.getDnForAttribute(null);
        String[] targetArray = new String[]{pattern};
        boolean bl = useLowercaseFilter = !PersistenceEntryManager.PERSITENCE_TYPES.ldap.name().equals(this.persistenceEntryManager.getPersistenceType(baseDn));
        if (useLowercaseFilter) {
            Filter displayNameFilter = Filter.createSubstringFilter((Filter)Filter.createLowercaseFilter((String)"displayName"), null, (String[])targetArray, null);
            Filter descriptionFilter = Filter.createSubstringFilter((Filter)Filter.createLowercaseFilter((String)"description"), null, (String[])targetArray, null);
            Filter nameFilter = Filter.createSubstringFilter((Filter)Filter.createLowercaseFilter((String)"jansAttrName"), null, (String[])targetArray, null);
            searchFilter = Filter.createORFilter((Filter[])new Filter[]{displayNameFilter, descriptionFilter, nameFilter});
        } else {
            Filter displayNameFilter = Filter.createSubstringFilter((String)"displayName", null, (String[])targetArray, null);
            Filter descriptionFilter = Filter.createSubstringFilter((String)"description", null, (String[])targetArray, null);
            Filter nameFilter = Filter.createSubstringFilter((String)"jansAttrName", null, (String[])targetArray, null);
            searchFilter = Filter.createORFilter((Filter[])new Filter[]{displayNameFilter, descriptionFilter, nameFilter});
        }
        return this.persistenceEntryManager.findEntries(baseDn, JansAttribute.class, searchFilter, sizeLimit);
    }

    public List<JansAttribute> searchAttributes(int sizeLimit) throws Exception {
        return this.persistenceEntryManager.findEntries(this.getDnForAttribute(null), JansAttribute.class, null, sizeLimit);
    }

    public List<JansAttribute> searchAttributes(int sizeLimit, boolean active) throws Exception {
        Filter activeFilter = Filter.createEqualityFilter((String)"jansStatus", (Object)"active");
        if (!active) {
            activeFilter = Filter.createEqualityFilter((String)"jansStatus", (Object)"inactive");
        }
        return this.persistenceEntryManager.findEntries(this.getDnForAttribute(null), JansAttribute.class, activeFilter, sizeLimit);
    }

    public List<JansAttribute> findAttributes(String pattern, int sizeLimit, boolean active) throws Exception {
        Filter activeFilter = Filter.createEqualityFilter((String)"jansStatus", (Object)"active");
        if (!active) {
            activeFilter = Filter.createEqualityFilter((String)"jansStatus", (Object)"inactive");
        }
        String[] targetArray = new String[]{pattern};
        Filter displayNameFilter = Filter.createSubstringFilter((String)"displayName", null, (String[])targetArray, null);
        Filter descriptionFilter = Filter.createSubstringFilter((String)"description", null, (String[])targetArray, null);
        Filter nameFilter = Filter.createSubstringFilter((String)"jansAttrName", null, (String[])targetArray, null);
        Filter searchFilter = Filter.createORFilter((Filter[])new Filter[]{displayNameFilter, descriptionFilter, nameFilter});
        return this.persistenceEntryManager.findEntries(this.getDnForAttribute(null), JansAttribute.class, Filter.createANDFilter((Filter[])new Filter[]{searchFilter, activeFilter}), sizeLimit);
    }

    public JansAttribute getAttributeByInum(String inum) {
        JansAttribute result = null;
        try {
            result = (JansAttribute)this.persistenceEntryManager.find(JansAttribute.class, (Object)this.getDnForAttribute(inum));
        }
        catch (Exception ex) {
            this.logger.error("Failed to load client entry", (Throwable)ex);
        }
        return result;
    }

    public void removeAttribute(JansAttribute attribute) {
        this.logger.trace("Removing attribute {}", (Object)attribute.getDisplayName());
        this.persistenceEntryManager.remove((Object)attribute);
    }

    public void addAttribute(JansAttribute attribute) {
        this.persistenceEntryManager.persist((Object)attribute);
    }

    public void updateAttribute(JansAttribute attribute) {
        this.persistenceEntryManager.merge((Object)attribute);
    }

    protected abstract boolean isUseLocalCache();
}

