/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.common.service.common;

import io.jans.as.common.model.common.User;
import io.jans.as.common.service.common.InumService;
import io.jans.as.model.util.Util;
import io.jans.model.GluuStatus;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.model.base.CustomAttribute;
import io.jans.orm.model.base.CustomObjectAttribute;
import io.jans.orm.search.filter.Filter;
import io.jans.service.DataSourceTypeService;
import io.jans.util.ArrayHelper;
import io.jans.util.StringHelper;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.Logger;

public abstract class UserService {
    public static final String[] USER_OBJECT_CLASSES = new String[]{"jansPerson"};
    @Inject
    protected PersistenceEntryManager persistenceEntryManager;
    @Inject
    protected DataSourceTypeService dataSourceTypeService;
    @Inject
    private Logger log;
    @Inject
    private InumService inumService;

    @Nullable
    public User getUserByDn(String dn, String ... returnAttributes) {
        if (Util.isNullOrEmpty((String)dn)) {
            return null;
        }
        return (User)((Object)this.persistenceEntryManager.find((Object)dn, User.class, returnAttributes));
    }

    @Nullable
    public User getUserByDnSilently(String dn, String ... returnAttributes) {
        try {
            return this.getUserByDn(dn, returnAttributes);
        }
        catch (Exception e) {
            this.log.trace("user's dn=" + dn, (Throwable)e);
            return null;
        }
    }

    public User getUserByInum(String inum, String ... returnAttributes) {
        if (StringHelper.isEmpty((String)inum)) {
            return null;
        }
        String userDn = this.getDnForUser(inum);
        return this.getUserByDn(userDn, returnAttributes);
    }

    public User getUser(String userId, String ... returnAttributes) {
        String escapedUserId = Util.escapeLog((Object)userId);
        this.log.debug("Getting user information from DB: userId = {}", (Object)escapedUserId);
        if (StringHelper.isEmpty((String)userId)) {
            return null;
        }
        String peopleBaseDn = this.getPeopleBaseDn();
        Filter userUidFilter = this.dataSourceTypeService.isSpanner(peopleBaseDn) ? Filter.createEqualityFilter((String)"uid", (Object)StringHelper.toLowerCase((String)userId)) : Filter.createEqualityFilter((Filter)Filter.createLowercaseFilter((String)"uid"), (Object)StringHelper.toLowerCase((String)userId));
        List entries = this.persistenceEntryManager.findEntries(peopleBaseDn, User.class, userUidFilter, returnAttributes);
        this.log.debug("Found {} entries for user id = {}", (Object)entries.size(), (Object)escapedUserId);
        return entries.isEmpty() ? null : (User)((Object)entries.get(0));
    }

    public String getUserInum(User user) {
        if (user == null) {
            return null;
        }
        return user.getAttribute("inum");
    }

    public String getUserInum(String userId) {
        User user = this.getUser(userId, "inum");
        return this.getUserInum(user);
    }

    public User updateUser(User user) {
        user.setUpdatedAt(new Date());
        this.persistenceEntryManager.merge((Object)user);
        return this.getUserByDn(user.getDn(), new String[0]);
    }

    public User addDefaultUser(String uid) {
        List<String> personCustomObjectClassList;
        String peopleBaseDN = this.getPeopleBaseDn();
        String inum = this.inumService.generatePeopleInum();
        User user = new User();
        user.setDn("inum=" + inum + "," + peopleBaseDN);
        user.setStatus(GluuStatus.ACTIVE);
        user.setCustomAttributes(Arrays.asList(new CustomObjectAttribute("inum", (Object)inum), new CustomObjectAttribute("displayName", (Object)("User " + uid + " added via Jans Auth custom plugin"))));
        user.setUserId(uid);
        if (this.dataSourceTypeService.isLDAP(user.getDn()) && (personCustomObjectClassList = this.getPersonCustomObjectClassList()) != null && !personCustomObjectClassList.isEmpty()) {
            user.setCustomObjectClasses(personCustomObjectClassList.toArray(new String[personCustomObjectClassList.size()]));
        }
        user.setCreatedAt(new Date());
        this.persistenceEntryManager.persist((Object)user);
        return this.getUser(uid, new String[0]);
    }

    public User addUser(User user, boolean active) {
        List<String> personCustomObjectClassList;
        String peopleBaseDN = this.getPeopleBaseDn();
        String inum = this.inumService.generatePeopleInum();
        user.setDn("inum=" + inum + "," + peopleBaseDN);
        user.setAttribute("inum", inum, false);
        GluuStatus status = active ? GluuStatus.ACTIVE : GluuStatus.REGISTER;
        user.setStatus(status);
        if (this.dataSourceTypeService.isLDAP(user.getDn()) && (personCustomObjectClassList = this.getPersonCustomObjectClassList()) != null && !personCustomObjectClassList.isEmpty()) {
            HashSet<Object> allObjectClasses = new HashSet<Object>();
            allObjectClasses.addAll(personCustomObjectClassList);
            Object[] currentObjectClasses = user.getCustomObjectClasses();
            if (ArrayHelper.isNotEmpty((Object[])currentObjectClasses)) {
                allObjectClasses.addAll(Arrays.asList(currentObjectClasses));
            }
            user.setCustomObjectClasses(allObjectClasses.toArray(new String[allObjectClasses.size()]));
        }
        user.setCreatedAt(new Date());
        this.persistenceEntryManager.persist((Object)user);
        return this.getUserByDn(user.getDn(), new String[0]);
    }

    public User getUserByAttribute(String attributeName, Object attributeValue) {
        return this.getUserByAttribute(attributeName, attributeValue, null);
    }

    public User getUserByAttribute(String attributeName, Object attributeValue, Boolean multiValued) {
        List<User> entries = this.getUsersByAttribute(attributeName, attributeValue, multiValued, 1);
        if (!entries.isEmpty()) {
            return entries.get(0);
        }
        return null;
    }

    public User getUniqueUserByAttributes(List<String> attributeNames, String attributeValue) {
        this.log.debug("Getting user information from LDAP: attributeNames = '{}', attributeValue = '{}'", attributeNames, (Object)attributeValue);
        if (attributeNames != null) {
            for (String attributeName : attributeNames) {
                User searchUser = new User();
                searchUser.setDn(this.getPeopleBaseDn());
                ArrayList<CustomObjectAttribute> customAttributes = new ArrayList<CustomObjectAttribute>();
                customAttributes.add(new CustomObjectAttribute(attributeName, (Object)attributeValue));
                searchUser.setCustomAttributes(customAttributes);
                try {
                    List entries = this.persistenceEntryManager.findEntries((Object)searchUser);
                    this.log.debug("Found '{}' entries", (Object)entries.size());
                    if (entries.size() == 1) {
                        return (User)((Object)entries.get(0));
                    }
                    if (entries.size() <= 1) continue;
                    break;
                }
                catch (Exception e) {
                    this.log.debug(e.getMessage(), (Throwable)e);
                }
            }
        }
        return null;
    }

    public List<User> getUsersByAttribute(String attributeName, Object attributeValue, Boolean multiValued, int limit) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Getting user information from LDAP: attributeName = '{}', attributeValue = '{}'", (Object)Util.escapeLog((Object)attributeName), (Object)Util.escapeLog((Object)attributeValue));
        }
        if (StringHelper.isEmpty((String)attributeName) || attributeValue == null) {
            return Collections.emptyList();
        }
        Filter filter = Filter.createEqualityFilter((String)attributeName, (Object)attributeValue);
        if (multiValued != null) {
            filter.multiValued(multiValued);
        }
        List entries = this.persistenceEntryManager.findEntries(this.getPeopleBaseDn(), User.class, filter, limit);
        this.log.debug("Found '{}' entries", (Object)entries.size());
        return entries;
    }

    public User getUserByAttributes(Object attributeValue, String[] attributeNames, String ... returnAttributes) {
        return this.getUserByAttributes(attributeValue, attributeNames, (Boolean)null, returnAttributes);
    }

    public User getUserByAttributes(Object attributeValue, String[] attributeNames, Boolean multiValued, String ... returnAttributes) {
        if (ArrayHelper.isEmpty((Object[])attributeNames)) {
            return null;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Getting user information from DB: {} = {}", (Object)ArrayHelper.toString((Object[])attributeNames), attributeValue);
        }
        String peopleBaseDn = this.getPeopleBaseDn();
        ArrayList<Filter> filters = new ArrayList<Filter>();
        for (String attributeName : attributeNames) {
            Filter filter = this.dataSourceTypeService.isSpanner(peopleBaseDn) ? Filter.createEqualityFilter((String)attributeName, (Object)attributeValue) : Filter.createEqualityFilter((Filter)Filter.createLowercaseFilter((String)attributeName), (Object)attributeValue);
            if (multiValued != null) {
                filter.multiValued(multiValued);
            }
            filters.add(filter);
        }
        Filter searchFiler = filters.size() == 1 ? (Filter)filters.get(0) : Filter.createORFilter(filters);
        List entries = this.persistenceEntryManager.findEntries(this.getPeopleBaseDn(), User.class, searchFiler, returnAttributes, 1);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Found {} entries for user {} = {}", new Object[]{entries.size(), ArrayHelper.toString((Object[])attributeNames), attributeValue});
        }
        return entries.isEmpty() ? null : (User)((Object)entries.get(0));
    }

    public User getUserByAttributes(List<CustomAttribute> attributes, boolean andFilter, String ... returnAttributes) {
        if (attributes == null) {
            return null;
        }
        this.log.debug("Getting user information using next attributes '{}'", attributes);
        ArrayList<Filter> filters = new ArrayList<Filter>();
        for (CustomAttribute attribute : attributes) {
            Filter filter = Filter.createEqualityFilter((String)attribute.getName(), (Object)attribute.getValues());
            filter.multiValued(Boolean.valueOf(attribute.isMultiValued()));
            filters.add(filter);
        }
        Filter searchFiler = filters.size() == 1 ? (Filter)filters.get(0) : (andFilter ? Filter.createANDFilter(filters) : Filter.createORFilter(filters));
        List entries = this.persistenceEntryManager.findEntries(this.getPeopleBaseDn(), User.class, searchFiler, returnAttributes, 1);
        this.log.debug("Found '{}' entries for user by next attributes '{}'", (Object)entries.size(), attributes);
        if (!entries.isEmpty()) {
            return (User)((Object)entries.get(0));
        }
        return null;
    }

    public List<User> getUsersBySample(User user, int limit) {
        this.log.debug("Getting user by sample");
        List entries = this.persistenceEntryManager.findEntries((Object)user, limit);
        this.log.debug("Found '{}' entries", (Object)entries.size());
        return entries;
    }

    public User addUserAttributeByUserInum(String userInum, String attributeName, Object attributeValue) {
        this.log.debug("Add user attribute by user inum  to LDAP: attributeName = '{}', attributeValue = '{}'", (Object)attributeName, attributeValue);
        User user = this.getUserByInum(userInum, new String[0]);
        if (user == null) {
            return null;
        }
        boolean result = this.addUserAttribute(user, attributeName, attributeValue);
        if (!result) {
            this.addUserAttribute(user, attributeName, attributeValue);
        }
        return this.updateUser(user);
    }

    public User addUserAttribute(String userId, String attributeName, Object attributeValue) {
        return this.addUserAttribute(userId, attributeName, attributeValue, null);
    }

    public User addUserAttribute(String userId, String attributeName, Object attributeValue, Boolean multiValued) {
        this.log.debug("Add user attribute to LDAP: attributeName = '{}', attributeValue = '{}'", (Object)attributeName, attributeValue);
        User user = this.getUser(userId, new String[0]);
        if (user == null) {
            return null;
        }
        boolean result = this.addUserAttribute(user, attributeName, attributeValue, multiValued);
        if (!result) {
            return null;
        }
        return this.updateUser(user);
    }

    public boolean addUserAttribute(User user, String attributeName, Object attributeValue) {
        return this.addUserAttribute(user, attributeName, attributeValue, null);
    }

    public boolean addUserAttribute(User user, String attributeName, Object attributeValue, Boolean multiValued) {
        CustomObjectAttribute customAttribute = this.getCustomAttribute(user, attributeName);
        if (customAttribute == null) {
            customAttribute = new CustomObjectAttribute(attributeName, attributeValue);
            user.getCustomAttributes().add(customAttribute);
        } else {
            List currentAttributeValues = customAttribute.getValues();
            ArrayList<Object> newAttributeValues = new ArrayList<Object>();
            newAttributeValues.addAll(currentAttributeValues);
            if (newAttributeValues.contains(attributeValue)) {
                return false;
            }
            newAttributeValues.add(attributeValue);
            customAttribute.setValues(newAttributeValues);
        }
        if (multiValued != null) {
            customAttribute.setMultiValued(multiValued.booleanValue());
        }
        return true;
    }

    public User removeUserAttributeValue(String userId, String attributeName, String attributeValue) {
        List currentAttributeValues;
        this.log.debug("Remove user attribute value from LDAP: attributeName = '{}', attributeValue = '{}'", (Object)attributeName, (Object)attributeValue);
        User user = this.getUser(userId, new String[0]);
        if (user == null) {
            return null;
        }
        CustomObjectAttribute customAttribute = this.getCustomAttribute(user, attributeName);
        if (customAttribute != null && (currentAttributeValues = customAttribute.getValues()).contains(attributeValue)) {
            ArrayList newAttributeValues = new ArrayList();
            newAttributeValues.addAll(currentAttributeValues);
            if (!currentAttributeValues.contains(attributeValue)) {
                return null;
            }
            newAttributeValues.remove(attributeValue);
            customAttribute.setValues(newAttributeValues);
        }
        return this.updateUser(user);
    }

    public User replaceUserAttribute(String userId, String attributeName, String oldAttributeValue, String newAttributeValue) {
        return this.replaceUserAttribute(userId, attributeName, oldAttributeValue, newAttributeValue, null);
    }

    public User replaceUserAttribute(String userId, String attributeName, String oldAttributeValue, String newAttributeValue, Boolean multiValued) {
        this.log.debug("Replace user attribute in LDAP: attributeName = '{}', oldAttributeValue = '{}', newAttributeValue = '{}'", new Object[]{attributeName, oldAttributeValue, newAttributeValue});
        User user = this.getUser(userId, new String[0]);
        if (user == null) {
            return null;
        }
        CustomObjectAttribute customAttribute = this.getCustomAttribute(user, attributeName);
        if (customAttribute != null) {
            List currentAttributeValues = customAttribute.getValues();
            ArrayList<String> newAttributeValues = new ArrayList<String>(currentAttributeValues);
            if (currentAttributeValues.contains(oldAttributeValue)) {
                newAttributeValues.remove(oldAttributeValue);
            }
            if (!newAttributeValues.contains(newAttributeValue)) {
                newAttributeValues.add(newAttributeValue);
            }
            customAttribute.setValues(newAttributeValues);
            if (multiValued != null) {
                customAttribute.setMultiValued(multiValued.booleanValue());
            }
        }
        return this.updateUser(user);
    }

    public CustomObjectAttribute getCustomAttribute(User user, String attributeName) {
        for (CustomObjectAttribute customAttribute : user.getCustomAttributes()) {
            if (!StringHelper.equalsIgnoreCase((String)attributeName, (String)customAttribute.getName())) continue;
            return customAttribute;
        }
        return null;
    }

    public void setCustomAttribute(User user, String attributeName, String attributeValue) {
        CustomObjectAttribute customAttribute = this.getCustomAttribute(user, attributeName);
        if (customAttribute == null) {
            customAttribute = new CustomObjectAttribute(attributeName);
            user.getCustomAttributes().add(customAttribute);
        }
        customAttribute.setValue((Object)attributeValue);
    }

    public List<User> getUsersWithPersistentJwts() {
        String baseDN = this.getPeopleBaseDn();
        Filter filter = Filter.createPresenceFilter((String)"jansPersistentJWT");
        return this.persistenceEntryManager.findEntries(baseDN, User.class, filter);
    }

    public String getDnForUser(String inum) {
        String peopleDn = this.getPeopleBaseDn();
        if (StringHelper.isEmpty((String)inum)) {
            return peopleDn;
        }
        return String.format("inum=%s,%s", inum, peopleDn);
    }

    public String getUserInumByDn(String dn) {
        if (StringHelper.isEmpty((String)dn)) {
            return null;
        }
        String peopleDn = this.getPeopleBaseDn();
        if (!dn.toLowerCase().endsWith(peopleDn.toLowerCase())) {
            return null;
        }
        String firstDnPart = dn.substring(0, dn.length() - peopleDn.length());
        String[] dnParts = firstDnPart.split(",");
        if (dnParts.length == 0) {
            return null;
        }
        String userInumPart = dnParts[dnParts.length - 1];
        String[] userInumParts = userInumPart.split("=");
        if (userInumParts.length == 2 && StringHelper.equalsIgnoreCase((String)userInumParts[0], (String)"inum")) {
            return userInumParts[1];
        }
        return null;
    }

    public String encodeGeneralizedTime(Date date) {
        String baseDn = this.getDnForUser(null);
        return this.persistenceEntryManager.encodeTime(baseDn, date);
    }

    public Date decodeGeneralizedTime(String date) {
        String baseDn = this.getDnForUser(null);
        return this.persistenceEntryManager.decodeTime(baseDn, date);
    }

    public abstract List<String> getPersonCustomObjectClassList();

    public abstract String getPeopleBaseDn();
}

