/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.common.service.common.fido2;

import io.jans.as.common.model.common.User;
import io.jans.as.common.service.common.UserService;
import io.jans.as.model.config.StaticConfiguration;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.model.base.SimpleBranch;
import io.jans.orm.model.fido2.Fido2RegistrationData;
import io.jans.orm.model.fido2.Fido2RegistrationEntry;
import io.jans.orm.model.fido2.Fido2RegistrationStatus;
import io.jans.orm.search.filter.Filter;
import io.jans.util.StringHelper;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import java.util.UUID;
import org.slf4j.Logger;

public abstract class RegistrationPersistenceService {
    @Inject
    protected Logger log;
    @Inject
    protected PersistenceEntryManager persistenceEntryManager;
    @Inject
    protected UserService userService;
    @Inject
    protected StaticConfiguration staticConfiguration;

    public void save(Fido2RegistrationEntry registrationEntry) {
        this.prepareBranch(registrationEntry.getUserInum());
        this.persistenceEntryManager.persist((Object)registrationEntry);
    }

    public void update(Fido2RegistrationEntry registrationEntry) {
        this.prepareBranch(registrationEntry.getUserInum());
        Date now = new GregorianCalendar(TimeZone.getTimeZone("UTC")).getTime();
        Fido2RegistrationData registrationData = registrationEntry.getRegistrationData();
        registrationData.setUpdatedDate(now);
        registrationData.setUpdatedBy(registrationData.getUsername());
        registrationEntry.setRegistrationStatus(registrationData.getStatus());
        this.persistenceEntryManager.merge((Object)registrationEntry);
    }

    public void addBranch(String baseDn) {
        SimpleBranch branch = new SimpleBranch();
        branch.setOrganizationalUnitName("fido2_register");
        branch.setDn(baseDn);
        this.persistenceEntryManager.persist((Object)branch);
    }

    public boolean containsBranch(String baseDn) {
        return this.persistenceEntryManager.contains(baseDn, SimpleBranch.class);
    }

    public String prepareBranch(String userInum) {
        String baseDn = this.getBaseDnForFido2RegistrationEntries(userInum);
        if (!this.persistenceEntryManager.hasBranchesSupport(baseDn)) {
            return baseDn;
        }
        if (!this.containsBranch(baseDn)) {
            this.addBranch(baseDn);
        }
        return baseDn;
    }

    public Fido2RegistrationEntry findRegisteredUserDevice(String userInum, String deviceId, String ... returnAttributes) {
        String baseDn = this.getBaseDnForFido2RegistrationEntries(userInum);
        if (this.persistenceEntryManager.hasBranchesSupport(baseDn) && !this.containsBranch(baseDn)) {
            return null;
        }
        String deviceDn = this.getDnForRegistrationEntry(userInum, deviceId);
        return (Fido2RegistrationEntry)this.persistenceEntryManager.find((Object)deviceDn, Fido2RegistrationEntry.class, returnAttributes);
    }

    public List<Fido2RegistrationEntry> findByRpRegisteredUserDevices(String userName, String rpId, String ... returnAttributes) {
        String userInum = this.userService.getUserInum(userName);
        if (userInum == null) {
            return Collections.emptyList();
        }
        String baseDn = this.getBaseDnForFido2RegistrationEntries(userInum);
        if (this.persistenceEntryManager.hasBranchesSupport(baseDn) && !this.containsBranch(baseDn)) {
            return Collections.emptyList();
        }
        Filter userInumFilter = Filter.createEqualityFilter((String)"personInum", (Object)userInum);
        Filter registeredFilter = Filter.createEqualityFilter((String)"jansStatus", (Object)Fido2RegistrationStatus.registered.getValue());
        Filter filter = null;
        if (StringHelper.isNotEmpty((String)rpId)) {
            Filter appIdFilter = Filter.createEqualityFilter((String)"jansApp", (Object)rpId);
            filter = Filter.createANDFilter((Filter[])new Filter[]{userInumFilter, registeredFilter, appIdFilter});
        } else {
            filter = Filter.createANDFilter((Filter[])new Filter[]{userInumFilter, registeredFilter});
        }
        List fido2RegistrationnEntries = this.persistenceEntryManager.findEntries(baseDn, Fido2RegistrationEntry.class, filter, returnAttributes);
        return fido2RegistrationnEntries;
    }

    public boolean attachDeviceRegistrationToUser(String userInum, String deviceDn) {
        return this.attachDeviceRegistrationToUser(userInum, deviceDn, null);
    }

    public boolean attachDeviceRegistrationToUser(String userInum, String deviceDn, String deviceName) {
        Fido2RegistrationEntry registrationEntry = (Fido2RegistrationEntry)this.persistenceEntryManager.find(Fido2RegistrationEntry.class, (Object)deviceDn);
        if (registrationEntry == null) {
            return false;
        }
        User user = this.userService.getUserByInum(userInum, "uid");
        if (user == null) {
            return false;
        }
        this.persistenceEntryManager.remove(deviceDn, Fido2RegistrationEntry.class);
        String id = UUID.randomUUID().toString();
        String userAttestationDn = this.getDnForRegistrationEntry(userInum, id);
        registrationEntry.setId(id);
        registrationEntry.setDn(userAttestationDn);
        registrationEntry.setUserInum(userInum);
        registrationEntry.setDisplayName(deviceName);
        Fido2RegistrationData registrationData = registrationEntry.getRegistrationData();
        registrationData.setUsername(user.getUserId());
        registrationEntry.clearExpiration();
        this.save(registrationEntry);
        return true;
    }

    public Fido2RegistrationEntry findOneStepUserDeviceRegistration(String deviceDn) {
        Fido2RegistrationEntry registrationEntry = (Fido2RegistrationEntry)this.persistenceEntryManager.find(Fido2RegistrationEntry.class, (Object)deviceDn);
        return registrationEntry;
    }

    public String getDnForRegistrationEntry(String userInum, String jsId) {
        String baseDn = this.getBaseDnForFido2RegistrationEntries(userInum);
        if (StringHelper.isEmpty((String)jsId)) {
            return baseDn;
        }
        return String.format("jansId=%s,%s", jsId, baseDn);
    }

    public String getBaseDnForFido2RegistrationEntries(String userInum) {
        String userBaseDn = this.getDnForUser(userInum);
        if (StringHelper.isEmpty((String)userInum)) {
            return userBaseDn;
        }
        return String.format("ou=fido2_register,%s", userBaseDn);
    }

    public String getDnForUser(String userInum) {
        String peopleDn = this.getBasedPeopleDn();
        if (StringHelper.isEmpty((String)userInum)) {
            return peopleDn;
        }
        return String.format("inum=%s,%s", userInum, peopleDn);
    }

    public String getBasedPeopleDn() {
        return this.staticConfiguration.getBaseDn().getPeople();
    }

    public abstract String getUserInum(String var1);
}

