/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.common.model.registration;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import io.jans.as.model.common.AuthenticationMethod;
import io.jans.as.model.common.BackchannelTokenDeliveryMode;
import io.jans.as.model.common.GrantType;
import io.jans.as.model.common.ResponseType;
import io.jans.as.model.common.SubjectType;
import io.jans.as.model.crypto.signature.AsymmetricSignatureAlgorithm;
import io.jans.as.model.register.ApplicationType;
import io.jans.as.persistence.model.ClientAttributes;
import io.jans.orm.annotation.AttributeName;
import io.jans.orm.annotation.AttributesList;
import io.jans.orm.annotation.CustomObjectClass;
import io.jans.orm.annotation.DataEntry;
import io.jans.orm.annotation.Expiration;
import io.jans.orm.annotation.JsonObject;
import io.jans.orm.annotation.LanguageTag;
import io.jans.orm.annotation.ObjectClass;
import io.jans.orm.model.base.CustomObjectAttribute;
import io.jans.orm.model.base.DeletableEntity;
import io.jans.orm.model.base.LocalizedString;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

@DataEntry(sortBy={"displayName"})
@ObjectClass(value="jansClnt")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Client
extends DeletableEntity
implements Serializable {
    private static final long serialVersionUID = -6832496019942067971L;
    @JsonProperty(value="inum")
    @AttributeName(name="inum", ignoreDuringUpdate=true)
    private String clientId;
    @AttributeName(name="jansClntSecret")
    private String clientSecret;
    @AttributeName(name="jansLogoutURI")
    private String frontChannelLogoutUri;
    @AttributeName(name="jansLogoutSessRequired")
    private Boolean frontChannelLogoutSessionRequired;
    @AttributeName(name="jansRegistrationAccessTkn")
    private String registrationAccessToken;
    @AttributeName(name="jansClntIdIssuedAt")
    private Date clientIdIssuedAt;
    @AttributeName(name="jansClntSecretExpAt")
    private Date clientSecretExpiresAt;
    @AttributeName(name="jansRedirectURI")
    private String[] redirectUris;
    @AttributeName(name="jansClaimRedirectURI")
    private String[] claimRedirectUris;
    @AttributeName(name="jansRespTyp")
    private ResponseType[] responseTypes;
    @AttributeName(name="jansGrantTyp")
    private GrantType[] grantTypes;
    @AttributeName(name="jansAppTyp")
    private ApplicationType applicationType = ApplicationType.WEB;
    @AttributeName(name="jansContact")
    private String[] contacts;
    @AttributeName(name="tknBndCnf")
    private String idTokenTokenBindingCnf;
    @AttributeName(name="displayName")
    private String clientName;
    @AttributeName(name="jansLogoURI")
    private String logoUri;
    @AttributeName(name="jansClntURI")
    private String clientUri;
    @AttributeName(name="jansPolicyURI")
    private String policyUri;
    @AttributeName(name="jansTosURI")
    private String tosUri;
    @AttributeName(name="displayNameLocalized")
    @JsonObject
    @LanguageTag
    private LocalizedString clientNameLocalized = new LocalizedString();
    @AttributeName(name="jansLogoURILocalized")
    @JsonObject
    @LanguageTag
    private LocalizedString logoUriLocalized = new LocalizedString();
    @AttributeName(name="jansClntURILocalized")
    @JsonObject
    @LanguageTag
    private LocalizedString clientUriLocalized = new LocalizedString();
    @AttributeName(name="jansPolicyURILocalized")
    @JsonObject
    @LanguageTag
    private LocalizedString policyUriLocalized = new LocalizedString();
    @AttributeName(name="jansTosURILocalized")
    @JsonObject
    @LanguageTag
    private LocalizedString tosUriLocalized = new LocalizedString();
    @AttributeName(name="jansJwksURI")
    private String jwksUri;
    @AttributeName(name="jansJwks")
    private String jwks;
    @AttributeName(name="jansSectorIdentifierURI")
    private String sectorIdentifierUri;
    @AttributeName(name="jansSubjectTyp")
    private SubjectType subjectType = SubjectType.PUBLIC;
    @AttributeName(name="jansIdTknSignedRespAlg")
    private String idTokenSignedResponseAlg;
    @AttributeName(name="jansIdTknEncRespAlg")
    private String idTokenEncryptedResponseAlg;
    @AttributeName(name="jansIdTknEncRespEnc")
    private String idTokenEncryptedResponseEnc;
    @AttributeName(name="jansSignedRespAlg")
    private String userInfoSignedResponseAlg;
    @AttributeName(name="jansUsrInfEncRespAlg")
    private String userInfoEncryptedResponseAlg;
    @AttributeName(name="jansUsrInfEncRespEnc")
    private String userInfoEncryptedResponseEnc;
    @AttributeName(name="jansReqObjSigAlg")
    private String requestObjectSigningAlg;
    @AttributeName(name="jansReqObjEncAlg")
    private String requestObjectEncryptionAlg;
    @AttributeName(name="jansReqObjEncEnc")
    private String requestObjectEncryptionEnc;
    @AttributeName(name="jansTknEndpointAuthMethod")
    @Schema(implementation=AuthenticationMethod.class, format="enum")
    private String tokenEndpointAuthMethod;
    @AttributeName(name="jansTknEndpointAuthSigAlg")
    private String tokenEndpointAuthSigningAlg;
    @AttributeName(name="jansDefMaxAge")
    private Integer defaultMaxAge;
    @AttributeName(name="jansDefAcrValues")
    private String[] defaultAcrValues;
    @AttributeName(name="jansInitiateLoginURI")
    private String initiateLoginUri;
    @AttributeName(name="jansPostLogoutRedirectURI")
    private String[] postLogoutRedirectUris;
    @AttributeName(name="jansReqURI")
    private String[] requestUris;
    @AttributeName(name="jansScope")
    private String[] scopes;
    @AttributeName(name="jansClaim")
    private String[] claims;
    @AttributeName(name="jansTrustedClnt")
    private boolean trustedClient;
    @AttributeName(name="jansLastAccessTime")
    private Date lastAccessTime;
    @AttributeName(name="jansLastLogonTime")
    private Date lastLogonTime;
    @AttributeName(name="jansPersistClntAuthzs")
    private boolean persistClientAuthorizations;
    @AttributeName(name="jansInclClaimsInIdTkn")
    private boolean includeClaimsInIdToken;
    @AttributeName(name="jansRefreshTknLife")
    private Integer refreshTokenLifetime;
    @AttributeName(name="jansAccessTknLife")
    private Integer accessTokenLifetime;
    @AttributesList(name="name", value="values", multiValued="multiValued", sortByName=true)
    private List<CustomObjectAttribute> customAttributes = new ArrayList<CustomObjectAttribute>();
    @CustomObjectClass
    private String[] customObjectClasses;
    @AttributeName(name="jansRptAsJwt")
    private boolean rptAsJwt = false;
    @AttributeName(name="jansAccessTknAsJwt")
    private boolean accessTokenAsJwt = false;
    @AttributeName(name="jansAccessTknSigAlg")
    private String accessTokenSigningAlg;
    @AttributeName(name="jansDisabled")
    private boolean disabled;
    @AttributeName(name="jansAuthorizedOrigins")
    private String[] authorizedOrigins;
    @AttributeName(name="jansSoftId")
    private String softwareId;
    @AttributeName(name="jansSoftVer")
    private String softwareVersion;
    @AttributeName(name="jansSoftStatement")
    private String softwareStatement;
    @AttributeName(name="jansAttrs")
    @JsonObject
    private ClientAttributes attributes;
    @AttributeName(name="jansBackchannelTknDeliveryMode")
    private BackchannelTokenDeliveryMode backchannelTokenDeliveryMode;
    @AttributeName(name="jansBackchannelClntNotificationEndpoint")
    private String backchannelClientNotificationEndpoint;
    @AttributeName(name="jansBackchannelAuthnReqSigAlg")
    private AsymmetricSignatureAlgorithm backchannelAuthenticationRequestSigningAlg;
    @AttributeName(name="jansBackchannelUsrCodeParameter")
    private Boolean backchannelUserCodeParameter;
    @AttributeName(name="description")
    private String description;
    @AttributeName(name="o")
    private String organization;
    @AttributeName(name="jansGrp")
    private String[] groups;
    @Expiration
    private Integer ttl;

    public String[] getGroups() {
        return this.groups;
    }

    public void setGroups(String[] groups) {
        this.groups = groups;
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public ClientAttributes getAttributes() {
        if (this.attributes == null) {
            this.attributes = new ClientAttributes();
        }
        return this.attributes;
    }

    public void setAttributes(ClientAttributes attributes) {
        this.attributes = attributes;
    }

    public Integer getTtl() {
        return this.ttl;
    }

    public void setTtl(Integer ttl) {
        this.ttl = ttl;
    }

    public boolean isRptAsJwt() {
        return this.rptAsJwt;
    }

    public void setRptAsJwt(boolean rptAsJwt) {
        this.rptAsJwt = rptAsJwt;
    }

    public boolean isAccessTokenAsJwt() {
        return this.accessTokenAsJwt;
    }

    public void setAccessTokenAsJwt(boolean accessTokenAsJwt) {
        this.accessTokenAsJwt = accessTokenAsJwt;
    }

    public String getAccessTokenSigningAlg() {
        return this.accessTokenSigningAlg;
    }

    public void setAccessTokenSigningAlg(String accessTokenSigningAlg) {
        this.accessTokenSigningAlg = accessTokenSigningAlg;
    }

    @Hidden
    public AuthenticationMethod getAuthenticationMethod() {
        return AuthenticationMethod.fromString((String)this.tokenEndpointAuthMethod);
    }

    public boolean hasAuthenticationMethod(AuthenticationMethod authenticationMethod) {
        return this.getAllAuthenticationMethods().contains(authenticationMethod);
    }

    @Hidden
    public Set<AuthenticationMethod> getAllAuthenticationMethods() {
        HashSet<AuthenticationMethod> set = new HashSet<AuthenticationMethod>();
        AuthenticationMethod authenticationMethod = this.getAuthenticationMethod();
        if (authenticationMethod != null) {
            set.add(authenticationMethod);
        }
        set.addAll(AuthenticationMethod.fromList((List)this.getAttributes().getAdditionalTokenEndpointAuthMethods()));
        return set;
    }

    public Boolean getFrontChannelLogoutSessionRequired() {
        if (this.frontChannelLogoutSessionRequired == null) {
            this.frontChannelLogoutSessionRequired = false;
        }
        return this.frontChannelLogoutSessionRequired;
    }

    public void setFrontChannelLogoutSessionRequired(Boolean frontChannelLogoutSessionRequired) {
        this.frontChannelLogoutSessionRequired = frontChannelLogoutSessionRequired;
    }

    public String getFrontChannelLogoutUri() {
        return this.frontChannelLogoutUri;
    }

    public void setFrontChannelLogoutUri(String frontChannelLogoutUri) {
        this.frontChannelLogoutUri = frontChannelLogoutUri;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getRegistrationAccessToken() {
        return this.registrationAccessToken;
    }

    public void setRegistrationAccessToken(String registrationAccessToken) {
        this.registrationAccessToken = registrationAccessToken;
    }

    public Date getClientIdIssuedAt() {
        return this.clientIdIssuedAt;
    }

    public void setClientIdIssuedAt(Date clientIdIssuedAt) {
        this.clientIdIssuedAt = clientIdIssuedAt;
    }

    public Date getClientSecretExpiresAt() {
        return this.clientSecretExpiresAt != null ? new Date(this.clientSecretExpiresAt.getTime()) : null;
    }

    public void setClientSecretExpiresAt(Date clientSecretExpiresAt) {
        this.clientSecretExpiresAt = clientSecretExpiresAt != null ? new Date(clientSecretExpiresAt.getTime()) : null;
    }

    public String[] getRedirectUris() {
        return this.redirectUris;
    }

    public void setRedirectUris(String[] redirectUris) {
        this.redirectUris = redirectUris;
    }

    public String[] getClaimRedirectUris() {
        return this.claimRedirectUris;
    }

    public void setClaimRedirectUris(String[] claimRedirectUris) {
        this.claimRedirectUris = claimRedirectUris;
    }

    public ResponseType[] getResponseTypes() {
        return this.responseTypes;
    }

    public void setResponseTypes(ResponseType[] responseTypes) {
        this.responseTypes = responseTypes;
    }

    public GrantType[] getGrantTypes() {
        if (this.grantTypes == null) {
            this.grantTypes = new GrantType[0];
        }
        return this.grantTypes;
    }

    public void setGrantTypes(GrantType[] grantTypes) {
        this.grantTypes = grantTypes;
    }

    public ApplicationType getApplicationType() {
        return this.applicationType;
    }

    public void setApplicationType(ApplicationType applicationType) {
        this.applicationType = applicationType;
    }

    public String[] getContacts() {
        return this.contacts;
    }

    public void setContacts(String[] contacts) {
        this.contacts = contacts;
    }

    public String getIdTokenTokenBindingCnf() {
        return this.idTokenTokenBindingCnf;
    }

    public void setIdTokenTokenBindingCnf(String idTokenTokenBindingCnf) {
        this.idTokenTokenBindingCnf = idTokenTokenBindingCnf;
    }

    @JsonIgnore
    public boolean isTokenBindingSupported() {
        return StringUtils.isNotBlank((CharSequence)this.idTokenTokenBindingCnf);
    }

    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public String getLogoUri() {
        return this.logoUri;
    }

    public void setLogoUri(String logoUri) {
        this.logoUri = logoUri;
    }

    public String getClientUri() {
        return this.clientUri;
    }

    public void setClientUri(String clientUri) {
        this.clientUri = clientUri;
    }

    public String getPolicyUri() {
        return this.policyUri;
    }

    public void setPolicyUri(String policyUri) {
        this.policyUri = policyUri;
    }

    public String getTosUri() {
        return this.tosUri;
    }

    public void setTosUri(String tosUri) {
        this.tosUri = tosUri;
    }

    public LocalizedString getClientNameLocalized() {
        return this.clientNameLocalized;
    }

    @JsonSetter
    public void setClientNameLocalized(LocalizedString clientNameLocalized) {
        this.clientNameLocalized = clientNameLocalized;
    }

    @JsonSetter
    public void setLogoUriLocalized(LocalizedString logoUriLocalized) {
        this.logoUriLocalized = logoUriLocalized;
    }

    @JsonSetter
    public void setClientUriLocalized(LocalizedString clientUriLocalized) {
        this.clientUriLocalized = clientUriLocalized;
    }

    @JsonSetter
    public void setPolicyUriLocalized(LocalizedString policyUriLocalized) {
        this.policyUriLocalized = policyUriLocalized;
    }

    @JsonSetter
    public void setTosUriLocalized(LocalizedString tosUriLocalized) {
        this.tosUriLocalized = tosUriLocalized;
    }

    @JsonIgnore
    public void setClientNameLocalized(String clientName) {
        this.clientName = clientName;
        this.clientNameLocalized.setValue(clientName);
    }

    @JsonIgnore
    public void setClientNameLocalized(String clientName, Locale locale) {
        if (StringUtils.isNotBlank((CharSequence)locale.toString())) {
            this.clientNameLocalized.setValue(clientName, locale);
        } else {
            this.setClientNameLocalized(clientName);
        }
    }

    public LocalizedString getLogoUriLocalized() {
        return this.logoUriLocalized;
    }

    @JsonIgnore
    public void setLogoUriLocalized(String logoUri) {
        this.logoUri = logoUri;
        this.logoUriLocalized.setValue(logoUri);
    }

    @JsonIgnore
    public void setLogoUriLocalized(String logoUri, Locale locale) {
        if (StringUtils.isNotBlank((CharSequence)locale.toString())) {
            this.logoUriLocalized.setValue(logoUri, locale);
        } else {
            this.setLogoUriLocalized(logoUri);
        }
    }

    public LocalizedString getClientUriLocalized() {
        return this.clientUriLocalized;
    }

    @JsonIgnore
    public void setClientUriLocalized(String clientUri) {
        this.clientUri = clientUri;
        this.clientUriLocalized.setValue(clientUri);
    }

    @JsonIgnore
    public void setClientUriLocalized(String clientUri, Locale locale) {
        if (StringUtils.isNotBlank((CharSequence)locale.toString())) {
            this.clientUriLocalized.setValue(clientUri, locale);
        } else {
            this.setClientUriLocalized(clientUri);
        }
    }

    public LocalizedString getPolicyUriLocalized() {
        return this.policyUriLocalized;
    }

    @JsonIgnore
    public void setPolicyUriLocalized(String policyUri) {
        this.policyUri = policyUri;
        this.policyUriLocalized.setValue(policyUri);
    }

    @JsonIgnore
    public void setPolicyUriLocalized(String policyUri, Locale locale) {
        if (StringUtils.isNotBlank((CharSequence)locale.toString())) {
            this.policyUriLocalized.setValue(policyUri, locale);
        } else {
            this.setPolicyUriLocalized(policyUri);
        }
    }

    public LocalizedString getTosUriLocalized() {
        return this.tosUriLocalized;
    }

    @JsonIgnore
    public void setTosUriLocalized(String tosUri) {
        this.tosUri = tosUri;
        this.tosUriLocalized.setValue(tosUri);
    }

    @JsonIgnore
    public void setTosUriLocalized(String tosUri, Locale locale) {
        if (StringUtils.isNotBlank((CharSequence)locale.toString())) {
            this.tosUriLocalized.setValue(tosUri, locale);
        } else {
            this.setTosUriLocalized(tosUri);
        }
    }

    public String getJwksUri() {
        return this.jwksUri;
    }

    public void setJwksUri(String jwksUri) {
        this.jwksUri = jwksUri;
    }

    public String getJwks() {
        return this.jwks;
    }

    public void setJwks(String jwks) {
        this.jwks = jwks;
    }

    public String getSectorIdentifierUri() {
        return this.sectorIdentifierUri;
    }

    public void setSectorIdentifierUri(String sectorIdentifierUri) {
        this.sectorIdentifierUri = sectorIdentifierUri;
    }

    public SubjectType getSubjectType() {
        return this.subjectType;
    }

    public void setSubjectType(SubjectType subjectType) {
        this.subjectType = subjectType;
    }

    public String getIdTokenSignedResponseAlg() {
        return this.idTokenSignedResponseAlg;
    }

    public void setIdTokenSignedResponseAlg(String idTokenSignedResponseAlg) {
        this.idTokenSignedResponseAlg = idTokenSignedResponseAlg;
    }

    public String getIdTokenEncryptedResponseAlg() {
        return this.idTokenEncryptedResponseAlg;
    }

    public void setIdTokenEncryptedResponseAlg(String idTokenEncryptedResponseAlg) {
        this.idTokenEncryptedResponseAlg = idTokenEncryptedResponseAlg;
    }

    public String getIdTokenEncryptedResponseEnc() {
        return this.idTokenEncryptedResponseEnc;
    }

    public void setIdTokenEncryptedResponseEnc(String idTokenEncryptedResponseEnc) {
        this.idTokenEncryptedResponseEnc = idTokenEncryptedResponseEnc;
    }

    public String getUserInfoSignedResponseAlg() {
        return this.userInfoSignedResponseAlg;
    }

    public void setUserInfoSignedResponseAlg(String userInfoSignedResponseAlg) {
        this.userInfoSignedResponseAlg = userInfoSignedResponseAlg;
    }

    public String getUserInfoEncryptedResponseAlg() {
        return this.userInfoEncryptedResponseAlg;
    }

    public void setUserInfoEncryptedResponseAlg(String userInfoEncryptedResponseAlg) {
        this.userInfoEncryptedResponseAlg = userInfoEncryptedResponseAlg;
    }

    public String getUserInfoEncryptedResponseEnc() {
        return this.userInfoEncryptedResponseEnc;
    }

    public void setUserInfoEncryptedResponseEnc(String userInfoEncryptedResponseEnc) {
        this.userInfoEncryptedResponseEnc = userInfoEncryptedResponseEnc;
    }

    public String getRequestObjectSigningAlg() {
        return this.requestObjectSigningAlg;
    }

    public void setRequestObjectSigningAlg(String requestObjectSigningAlg) {
        this.requestObjectSigningAlg = requestObjectSigningAlg;
    }

    public String getRequestObjectEncryptionAlg() {
        return this.requestObjectEncryptionAlg;
    }

    public void setRequestObjectEncryptionAlg(String requestObjectEncryptionAlg) {
        this.requestObjectEncryptionAlg = requestObjectEncryptionAlg;
    }

    public String getRequestObjectEncryptionEnc() {
        return this.requestObjectEncryptionEnc;
    }

    public void setRequestObjectEncryptionEnc(String requestObjectEncryptionEnc) {
        this.requestObjectEncryptionEnc = requestObjectEncryptionEnc;
    }

    @Schema(implementation=AuthenticationMethod.class, format="enum")
    public String getTokenEndpointAuthMethod() {
        return this.tokenEndpointAuthMethod;
    }

    public void setTokenEndpointAuthMethod(String tokenEndpointAuthMethod) {
        this.tokenEndpointAuthMethod = tokenEndpointAuthMethod;
    }

    public String getTokenEndpointAuthSigningAlg() {
        return this.tokenEndpointAuthSigningAlg;
    }

    public void setTokenEndpointAuthSigningAlg(String tokenEndpointAuthSigningAlg) {
        this.tokenEndpointAuthSigningAlg = tokenEndpointAuthSigningAlg;
    }

    public Integer getDefaultMaxAge() {
        return this.defaultMaxAge;
    }

    public void setDefaultMaxAge(Integer defaultMaxAge) {
        this.defaultMaxAge = defaultMaxAge;
    }

    public String[] getDefaultAcrValues() {
        return this.defaultAcrValues;
    }

    public void setDefaultAcrValues(String[] defaultAcrValues) {
        this.defaultAcrValues = defaultAcrValues;
    }

    public String getInitiateLoginUri() {
        return this.initiateLoginUri;
    }

    public void setInitiateLoginUri(String initiateLoginUri) {
        this.initiateLoginUri = initiateLoginUri;
    }

    public String[] getPostLogoutRedirectUris() {
        return this.postLogoutRedirectUris;
    }

    public void setPostLogoutRedirectUris(String[] postLogoutRedirectUris) {
        this.postLogoutRedirectUris = postLogoutRedirectUris;
    }

    public String[] getRequestUris() {
        return this.requestUris;
    }

    public void setRequestUris(String[] requestUris) {
        this.requestUris = requestUris;
    }

    public String[] getScopes() {
        return this.scopes;
    }

    public void setScopes(String[] scopes) {
        this.scopes = scopes;
    }

    public String[] getClaims() {
        return this.claims;
    }

    public void setClaims(String[] claims) {
        this.claims = claims;
    }

    public boolean getTrustedClient() {
        return this.trustedClient;
    }

    public void setTrustedClient(boolean trustedClient) {
        this.trustedClient = trustedClient;
    }

    public Date getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void setLastAccessTime(Date lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    public Date getLastLogonTime() {
        return this.lastLogonTime;
    }

    public void setLastLogonTime(Date lastLogonTime) {
        this.lastLogonTime = lastLogonTime;
    }

    public boolean getPersistClientAuthorizations() {
        return this.persistClientAuthorizations;
    }

    public void setPersistClientAuthorizations(boolean persistClientAuthorizations) {
        this.persistClientAuthorizations = persistClientAuthorizations;
    }

    public boolean isIncludeClaimsInIdToken() {
        return this.includeClaimsInIdToken;
    }

    public void setIncludeClaimsInIdToken(boolean includeClaimsInIdToken) {
        this.includeClaimsInIdToken = includeClaimsInIdToken;
    }

    public Integer getRefreshTokenLifetime() {
        return this.refreshTokenLifetime;
    }

    public void setRefreshTokenLifetime(Integer refreshTokenLifetime) {
        this.refreshTokenLifetime = refreshTokenLifetime;
    }

    public Integer getAccessTokenLifetime() {
        return this.accessTokenLifetime;
    }

    public void setAccessTokenLifetime(Integer accessTokenLifetime) {
        this.accessTokenLifetime = accessTokenLifetime;
    }

    public List<CustomObjectAttribute> getCustomAttributes() {
        return this.customAttributes;
    }

    public void setCustomAttributes(List<CustomObjectAttribute> customAttributes) {
        this.customAttributes = customAttributes;
    }

    public String[] getCustomObjectClasses() {
        return this.customObjectClasses;
    }

    public void setCustomObjectClasses(String[] customObjectClasses) {
        this.customObjectClasses = customObjectClasses;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public String[] getAuthorizedOrigins() {
        return this.authorizedOrigins;
    }

    public void setAuthorizedOrigins(String[] authorizedOrigins) {
        this.authorizedOrigins = authorizedOrigins;
    }

    public String getSoftwareId() {
        return this.softwareId;
    }

    public void setSoftwareId(String softwareId) {
        this.softwareId = softwareId;
    }

    public String getSoftwareVersion() {
        return this.softwareVersion;
    }

    public void setSoftwareVersion(String jsSoftVer) {
        this.softwareVersion = jsSoftVer;
    }

    public String getSoftwareStatement() {
        return this.softwareStatement;
    }

    public void setSoftwareStatement(String softwareStatement) {
        this.softwareStatement = softwareStatement;
    }

    public BackchannelTokenDeliveryMode getBackchannelTokenDeliveryMode() {
        return this.backchannelTokenDeliveryMode;
    }

    public void setBackchannelTokenDeliveryMode(BackchannelTokenDeliveryMode backchannelTokenDeliveryMode) {
        this.backchannelTokenDeliveryMode = backchannelTokenDeliveryMode;
    }

    public String getBackchannelClientNotificationEndpoint() {
        return this.backchannelClientNotificationEndpoint;
    }

    public void setBackchannelClientNotificationEndpoint(String backchannelClientNotificationEndpoint) {
        this.backchannelClientNotificationEndpoint = backchannelClientNotificationEndpoint;
    }

    public AsymmetricSignatureAlgorithm getBackchannelAuthenticationRequestSigningAlg() {
        return this.backchannelAuthenticationRequestSigningAlg;
    }

    public void setBackchannelAuthenticationRequestSigningAlg(AsymmetricSignatureAlgorithm backchannelAuthenticationRequestSigningAlg) {
        this.backchannelAuthenticationRequestSigningAlg = backchannelAuthenticationRequestSigningAlg;
    }

    public Boolean getBackchannelUserCodeParameter() {
        return this.backchannelUserCodeParameter;
    }

    public void setBackchannelUserCodeParameter(Boolean backchannelUserCodeParameter) {
        this.backchannelUserCodeParameter = backchannelUserCodeParameter;
    }

    public String getDisplayName() {
        return this.getClientName();
    }

    public void setDisplayName(String displayName) {
        this.setClientName(displayName);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

