/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.common.model.registration;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.jans.as.common.model.registration.Client;
import io.jans.as.model.util.Util;
import java.io.IOException;
import java.util.Locale;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class ClientSerializationTest {
    @Test
    public void deserialization_whenSerialized_shouldGetCorrectValues() throws IOException {
        Client c = new Client();
        c.setClientName("name");
        c.setClientNameLocalized("myLocalized");
        c.setClientNameLocalized("myLocalized_canada", Locale.CANADA);
        c.setClientNameLocalized("myLocalized_canadaFR", Locale.CANADA_FRENCH);
        ObjectMapper mapper = Util.createJsonMapper();
        mapper.setDefaultPropertyInclusion(JsonInclude.Include.NON_EMPTY);
        String asJson = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)c);
        Client client = (Client)mapper.readValue(asJson, Client.class);
        AssertJUnit.assertNotNull((Object)client);
        AssertJUnit.assertEquals((String)"myLocalized", (String)client.getClientName());
        AssertJUnit.assertEquals((String)"myLocalized", (String)client.getClientNameLocalized().getValue());
        AssertJUnit.assertEquals((String)"myLocalized_canada", (String)client.getClientNameLocalized().getValue(Locale.CANADA));
        AssertJUnit.assertEquals((String)"myLocalized_canadaFR", (String)client.getClientNameLocalized().getValue(Locale.CANADA_FRENCH));
    }
}

