/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.common.model.registration;

import com.google.common.collect.Lists;
import io.jans.as.common.model.registration.Client;
import io.jans.as.model.common.AuthenticationMethod;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ClientTest {
    @Test
    public void hasAuthenticationMethod_whenHasMainValue_shouldReturnTrue() {
        Client client = new Client();
        client.setTokenEndpointAuthMethod("client_secret_basic");
        Assert.assertTrue((boolean)client.hasAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_BASIC));
    }

    @Test
    public void hasAuthenticationMethod_whenAdditionalValueHasIt_shouldReturnTrue() {
        Client client = new Client();
        client.setTokenEndpointAuthMethod("client_secret_basic");
        client.getAttributes().setAdditionalTokenEndpointAuthMethods((List)Lists.newArrayList((Object[])new String[]{"client_secret_jwt"}));
        Assert.assertTrue((boolean)client.hasAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_BASIC));
    }

    @Test
    public void hasAuthenticationMethod_whenDoesNotHaveValue_shouldReturnFalse() {
        Client client = new Client();
        client.setTokenEndpointAuthMethod("client_secret_basic");
        Assert.assertFalse((boolean)client.hasAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_JWT));
    }
}

