/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.common.service.common;

import io.jans.as.common.service.common.ExternalIdGeneratorService;
import io.jans.as.common.service.common.InumService;
import io.jans.as.model.common.IdType;
import java.util.regex.Pattern;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.testng.MockitoTestNGListener;
import org.slf4j.Logger;
import org.testng.Assert;
import org.testng.annotations.Listeners;
import org.testng.annotations.Test;

@Listeners(value={MockitoTestNGListener.class})
public class InumServiceTest {
    @InjectMocks
    private InumService inumService;
    @Mock
    private Logger log;
    @Mock
    private ExternalIdGeneratorService externalIdGenerationService;
    private static final Pattern UUID_REGEX_PATTERN = Pattern.compile("^[{]?[0-9a-fA-F]{8}-([0-9a-fA-F]{4}-){3}[0-9a-fA-F]{12}[}]?$");

    @Test
    public void generateClientInum_isEnabledFalse_notNull() {
        ((ExternalIdGeneratorService)Mockito.doReturn((Object)false).when((Object)this.externalIdGenerationService)).isEnabled();
        String id = this.inumService.generateClientInum();
        Assert.assertTrue((boolean)UUID_REGEX_PATTERN.matcher(id).matches());
        Assert.assertNotNull((Object)id);
        ((ExternalIdGeneratorService)Mockito.verify((Object)this.externalIdGenerationService)).isEnabled();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.externalIdGenerationService, this.log});
    }

    @Test
    public void generatePeopleInum_executeExternalDefaultGenerateIdMethodNull_notNull() {
        ((ExternalIdGeneratorService)Mockito.doReturn((Object)true).when((Object)this.externalIdGenerationService)).isEnabled();
        ((ExternalIdGeneratorService)Mockito.doReturn(null).when((Object)this.externalIdGenerationService)).executeExternalDefaultGenerateIdMethod(Mockito.anyString(), Mockito.anyString(), Mockito.anyString());
        String id = this.inumService.generatePeopleInum();
        Assert.assertTrue((boolean)UUID_REGEX_PATTERN.matcher(id).matches());
        Assert.assertNotNull((Object)id);
        this.verifyInteractions(IdType.PEOPLE.getType());
    }

    @Test
    public void generateClientInum_executeExternalDefaultGenerateIdMethodNull_notNull() {
        ((ExternalIdGeneratorService)Mockito.doReturn((Object)true).when((Object)this.externalIdGenerationService)).isEnabled();
        ((ExternalIdGeneratorService)Mockito.doReturn(null).when((Object)this.externalIdGenerationService)).executeExternalDefaultGenerateIdMethod(Mockito.anyString(), Mockito.anyString(), Mockito.anyString());
        String id = this.inumService.generateClientInum();
        Assert.assertTrue((boolean)UUID_REGEX_PATTERN.matcher(id).matches());
        Assert.assertNotNull((Object)id);
        this.verifyInteractions(IdType.CLIENTS.getType());
    }

    @Test
    public void generateClientInum_executeExternalDefaultGenerateIdMethodEmpty_notNull() {
        ((ExternalIdGeneratorService)Mockito.doReturn((Object)true).when((Object)this.externalIdGenerationService)).isEnabled();
        ((ExternalIdGeneratorService)Mockito.doReturn((Object)"").when((Object)this.externalIdGenerationService)).executeExternalDefaultGenerateIdMethod(Mockito.anyString(), Mockito.anyString(), Mockito.anyString());
        String id = this.inumService.generateClientInum();
        Assert.assertTrue((boolean)UUID_REGEX_PATTERN.matcher(id).matches());
        Assert.assertNotNull((Object)id);
        this.verifyInteractions(IdType.CLIENTS.getType());
    }

    @Test
    public void generateClientInum_executeExternalDefaultGenerateIdMethodReturnValueNotUUID_notNull() {
        String generatedId = "9fcea0f4";
        ((ExternalIdGeneratorService)Mockito.doReturn((Object)true).when((Object)this.externalIdGenerationService)).isEnabled();
        ((ExternalIdGeneratorService)Mockito.doReturn((Object)"9fcea0f4").when((Object)this.externalIdGenerationService)).executeExternalDefaultGenerateIdMethod(Mockito.anyString(), Mockito.anyString(), Mockito.anyString());
        String id = this.inumService.generateClientInum();
        Assert.assertNotNull((Object)id);
        Assert.assertEquals((String)id, (String)"9fcea0f4");
        Assert.assertFalse((boolean)UUID_REGEX_PATTERN.matcher(id).matches());
        this.verifyInteractions(IdType.CLIENTS.getType());
    }

    private void verifyInteractions(String idType) {
        ((ExternalIdGeneratorService)Mockito.verify((Object)this.externalIdGenerationService)).isEnabled();
        ((ExternalIdGeneratorService)Mockito.verify((Object)this.externalIdGenerationService)).executeExternalDefaultGenerateIdMethod((String)Mockito.eq((Object)"jans-auth"), (String)Mockito.eq((Object)idType), (String)Mockito.eq((Object)""));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.externalIdGenerationService, this.log});
    }
}

