/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.common.util;

import io.jans.as.common.util.RedirectUri;
import io.jans.as.model.common.ResponseMode;
import io.jans.as.model.common.ResponseType;
import io.jans.as.model.crypto.AbstractCryptoProvider;
import io.jans.as.model.crypto.encryption.BlockEncryptionAlgorithm;
import io.jans.as.model.crypto.encryption.KeyEncryptionAlgorithm;
import io.jans.as.model.crypto.signature.SignatureAlgorithm;
import io.jans.as.model.exception.CryptoProviderException;
import io.jans.as.model.jwk.Algorithm;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URLEncoder;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import org.json.JSONObject;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.testng.MockitoTestNGListener;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Listeners;
import org.testng.annotations.Test;

@Listeners(value={MockitoTestNGListener.class})
public class RedirectUriTest {
    @Test
    public void html_forFormPostWithRxssAttack_shouldEscapeInjectedScript() {
        RedirectUri redirectUri = new RedirectUri("https://example.info/identity/authcode.htm", Collections.singletonList(ResponseType.CODE), ResponseMode.FORM_POST);
        redirectUri.parseQueryString("https://example.info/oxauth/restv1/authorize?client_id=1001.9a0d0cdb-8fe5-4239-a459-e7cf9cb9fe34&redirect_uri=https%3A%2F%2Fyuriyz-kind-honeybee.gluu.info%2Fidentity%2Fauthcode.htm&response_mode=form_post&state=http://aaa&foo\"><script>alert(location.href)</script>");
        String html = redirectUri.toString();
        AssertJUnit.assertFalse((boolean)html.contains("<script>"));
        AssertJUnit.assertFalse((boolean)html.contains("</script>"));
    }

    @Test
    public void parseQueryString_queryStringNull_EmptyResult() {
        RedirectUri redirectUri = this.getRedirectUriTemplateGetQueryString(null, null, null, null);
        redirectUri.parseQueryString(null);
        Assert.assertEquals((int)redirectUri.getResponseParamentersSize(), (int)0);
    }

    @Test
    public void parseQueryString_oneParam_size1() throws UnsupportedEncodingException {
        RedirectUri redirectUri = this.getRedirectUriTemplateGetQueryString(null, null, null, null);
        redirectUri.parseQueryString(this.encodeUTF8("expires_in") + "=");
        Assert.assertEquals((int)redirectUri.getResponseParamentersSize(), (int)1);
        Assert.assertNull((Object)redirectUri.getResponseParameter("expires_in"));
    }

    @Test
    public void parseQueryString_threeParams_size3() throws UnsupportedEncodingException {
        RedirectUri redirectUri = this.getRedirectUriTemplateGetQueryString(null, null, null, null);
        String p_code = this.encodeUTF8("code");
        String p_expires_in = this.encodeUTF8("expires_in");
        String p_access_token = this.encodeUTF8("access_token");
        String code = this.encodeUTF8("12345");
        String expires_in = this.encodeUTF8("30000");
        String token = this.encodeUTF8("tk123");
        redirectUri.parseQueryString(p_code + "=" + code + "&" + p_expires_in + "=" + expires_in + "&" + p_access_token + "=" + token);
        Assert.assertEquals((int)redirectUri.getResponseParamentersSize(), (int)3);
        Assert.assertEquals((String)redirectUri.getResponseParameter(p_code), (String)code);
        Assert.assertEquals((String)redirectUri.getResponseParameter(p_expires_in), (String)expires_in);
        Assert.assertEquals((String)redirectUri.getResponseParameter(p_access_token), (String)token);
    }

    @Test
    public void parseQueryString_threeParamsOneNull_size3() throws UnsupportedEncodingException {
        RedirectUri redirectUri = this.getRedirectUriTemplateGetQueryString(null, null, null, null);
        String p_code = this.encodeUTF8("code");
        String p_expires_in = this.encodeUTF8("expires_in");
        String p_token = this.encodeUTF8("access_token");
        String code = this.encodeUTF8("12345");
        String token = this.encodeUTF8("tk123");
        redirectUri.parseQueryString(p_code + "=" + code + "&" + p_expires_in + "=&" + p_token + "=" + token);
        Assert.assertEquals((int)redirectUri.getResponseParamentersSize(), (int)3);
        Assert.assertEquals((String)redirectUri.getResponseParameter(p_code), (String)code);
        Assert.assertNull((Object)redirectUri.getResponseParameter(p_expires_in));
        Assert.assertEquals((String)redirectUri.getResponseParameter(p_token), (String)token);
    }

    @Test
    public void getQueryString_noResponseMode_responseParametersEncoded() throws UnsupportedEncodingException {
        RedirectUri redirectUri = this.getRedirectUriTemplateGetQueryString(null, null, null, null);
        redirectUri.addResponseParameter("code", "12345");
        redirectUri.addResponseParameter("expires_in", "30000");
        redirectUri.addResponseParameter("access_token", "tk12345");
        String queryResult = redirectUri.getQueryString();
        System.out.println(queryResult);
        this.assertNoEmptyQueryString(queryResult, "code", 3);
        Assert.assertEquals((String)queryResult, (String)"access_token=tk12345&code=12345&expires_in=30000");
    }

    @Test
    public void getQueryString_responseModeFormPostJWT_responseEncodedNoEmpty() throws CryptoProviderException {
        RedirectUri redirectUri = this.getRedirectUriTemplateGetQueryString(ResponseMode.FORM_POST_JWT, null, null, null);
        AbstractCryptoProvider cryptoProvider = (AbstractCryptoProvider)Mockito.mock(AbstractCryptoProvider.class);
        Mockito.when((Object)cryptoProvider.sign(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (SignatureAlgorithm)Mockito.any())).thenReturn((Object)"12345");
        redirectUri.setCryptoProvider(cryptoProvider);
        redirectUri.addResponseParameter("expires_in", "3000");
        String queryResult = redirectUri.getQueryString();
        System.out.println(queryResult);
        Assert.assertTrue((queryResult.length() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)queryResult, (String)"eyJraWQiOiJrZXkxMjMiLCJ0eXAiOiJKV1QiLCJhbGciOiJSUzI1NiJ9.eyJpc3MiOiJ1c2VyMTIzIiwiZXhwIjoiMzAwMCIsImV4cGlyZXNfaW4iOiIzMDAwIn0.12345");
    }

    @Test
    public void getQueryString_withEncriptionAlgorithm128PublicKeyInvalid_responseEmptyThrowInvalid() throws CryptoProviderException {
        RedirectUri redirectUri = this.getRedirectUriTemplateGetQueryString(ResponseMode.JWT, KeyEncryptionAlgorithm.RSA1_5, BlockEncryptionAlgorithm.A256GCM, null);
        AbstractCryptoProvider cryptoProvider = (AbstractCryptoProvider)Mockito.mock(AbstractCryptoProvider.class);
        Mockito.when((Object)cryptoProvider.getPublicKey(ArgumentMatchers.anyString(), (JSONObject)Mockito.any(), (Algorithm)Mockito.any())).thenReturn(null);
        redirectUri.setCryptoProvider(cryptoProvider);
        String queryResult = redirectUri.getQueryString();
        System.out.println(queryResult);
        Assert.assertEquals((String)queryResult, (String)"");
    }

    @Test
    public void getQueryString_withEncriptionAlgorithmRSANoSignatureAlgorithm_responseEncoded() throws CryptoProviderException, UnsupportedEncodingException, NoSuchAlgorithmException, InvalidKeySpecException {
        RedirectUri redirectUri = this.getRedirectUriTemplateGetQueryString(ResponseMode.JWT, KeyEncryptionAlgorithm.RSA1_5, BlockEncryptionAlgorithm.A256GCM, null);
        AbstractCryptoProvider cryptoProvider = (AbstractCryptoProvider)Mockito.mock(AbstractCryptoProvider.class);
        Mockito.when((Object)cryptoProvider.getPublicKey(ArgumentMatchers.anyString(), (JSONObject)Mockito.any(), (Algorithm)Mockito.any())).thenReturn((Object)this.getRSAPublicKey());
        redirectUri.setCryptoProvider(cryptoProvider);
        redirectUri.addResponseParameter("expires_in", "1644270473301");
        String queryResult = redirectUri.getQueryString();
        System.out.println(queryResult);
        this.assertNoEmptyQueryString(queryResult, "response", 1);
        Assert.assertTrue((boolean)queryResult.startsWith("response=eyJ0eXAiOiJKV1QiLCJlbmMiOiJBMjU2R0NNIiwiYWxnIjoiUlNBMV81In0."));
    }

    @Test
    public void getQueryString_withEncriptionAlgorithm128NoSignatureAlgorithm_responseEncoded() throws UnsupportedEncodingException {
        RedirectUri redirectUri = this.getRedirectUriTemplateGetQueryString(ResponseMode.JWT, KeyEncryptionAlgorithm.A128KW, BlockEncryptionAlgorithm.A128GCM, null);
        AbstractCryptoProvider cryptoProvider = (AbstractCryptoProvider)Mockito.mock(AbstractCryptoProvider.class);
        redirectUri.setCryptoProvider(cryptoProvider);
        redirectUri.setNestedKeyId("nestedKey123");
        redirectUri.setNestedSharedSecret("nested_shared_secret");
        redirectUri.setSharedSymmetricKey("0123456789012345".getBytes());
        redirectUri.addResponseParameter("expires_in", "1644270473301");
        String queryResult = redirectUri.getQueryString();
        System.out.println(queryResult);
        this.assertNoEmptyQueryString(queryResult, "response", 1);
        Assert.assertTrue((boolean)queryResult.startsWith("response=eyJ0eXAiOiJKV1QiLCJlbmMiOiJBMTI4R0NNIiwiYWxnIjoiQTEyOEtXIn0."));
    }

    @Test
    public void getQueryString_withEncriptionAlgorithmRSAAndSignatureAlgorithm_responseEncoded() throws UnsupportedEncodingException, CryptoProviderException, NoSuchAlgorithmException, InvalidKeySpecException {
        RedirectUri redirectUri = this.getRedirectUriTemplateGetQueryString(ResponseMode.JWT, KeyEncryptionAlgorithm.RSA1_5, BlockEncryptionAlgorithm.A256GCM, SignatureAlgorithm.HS256);
        AbstractCryptoProvider cryptoProvider = (AbstractCryptoProvider)Mockito.mock(AbstractCryptoProvider.class);
        Mockito.when((Object)cryptoProvider.getPublicKey(ArgumentMatchers.anyString(), (JSONObject)Mockito.any(), (Algorithm)Mockito.any())).thenReturn((Object)this.getRSAPublicKey());
        Mockito.when((Object)cryptoProvider.sign(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (SignatureAlgorithm)Mockito.any())).thenReturn((Object)"12345");
        redirectUri.setCryptoProvider(cryptoProvider);
        redirectUri.setNestedKeyId("nestedKey123");
        redirectUri.setNestedSharedSecret("nested_shared_secret");
        String queryResult = redirectUri.getQueryString();
        System.out.println(queryResult);
        this.assertNoEmptyQueryString(queryResult, "response", 1);
        Assert.assertTrue((boolean)queryResult.startsWith("response=eyJjdHkiOiJKV1QiLCJ0eXAiOiJKV1QiLCJlbmMiOiJBMjU2R0NNIiwiYWxnIjoiUlNBMV81In0."));
    }

    @Test
    public void getQueryString_withEncriptionAlgorithm128KWAndSignatureAlgorithm_responseEncoded() throws UnsupportedEncodingException, CryptoProviderException {
        RedirectUri redirectUri = this.getRedirectUriTemplateGetQueryString(ResponseMode.JWT, KeyEncryptionAlgorithm.A128KW, BlockEncryptionAlgorithm.A128GCM, SignatureAlgorithm.HS256);
        AbstractCryptoProvider cryptoProvider = (AbstractCryptoProvider)Mockito.mock(AbstractCryptoProvider.class);
        Mockito.when((Object)cryptoProvider.sign(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (SignatureAlgorithm)Mockito.any(SignatureAlgorithm.class))).thenReturn((Object)"12345");
        redirectUri.setCryptoProvider(cryptoProvider);
        redirectUri.setNestedKeyId("nestedKey123");
        redirectUri.setNestedSharedSecret("nested_shared_secret");
        redirectUri.setSharedSymmetricKey("0123456789012345".getBytes());
        redirectUri.addResponseParameter("expires_in", "1644270473301");
        String queryResult = redirectUri.getQueryString();
        System.out.println(queryResult);
        this.assertNoEmptyQueryString(queryResult, "response", 1);
        Assert.assertTrue((boolean)queryResult.startsWith("response=eyJjdHkiOiJKV1QiLCJ0eXAiOiJKV1QiLCJlbmMiOiJBMTI4R0NNIiwiYWxnIjoiQTEyOEtXIn0."));
    }

    @Test
    public void getQueryString_noEncriptionAlgorithmNoSignatureAlgorithm_responseEncoded() throws UnsupportedEncodingException, CryptoProviderException {
        RedirectUri redirectUri = this.getRedirectUriTemplateGetQueryString(ResponseMode.JWT, null, null, null);
        AbstractCryptoProvider cryptoProvider = (AbstractCryptoProvider)Mockito.mock(AbstractCryptoProvider.class);
        Mockito.when((Object)cryptoProvider.sign(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (SignatureAlgorithm)Mockito.any(SignatureAlgorithm.class))).thenReturn((Object)"12345");
        redirectUri.setCryptoProvider(cryptoProvider);
        String queryResult = redirectUri.getQueryString();
        System.out.println(queryResult);
        this.assertNoEmptyQueryString(queryResult, "response", 1);
        Assert.assertTrue((boolean)queryResult.startsWith("response=eyJraWQiOiJrZXkxMjMiLCJ0eXAiOiJKV1QiLCJhbGciOiJSUzI1NiJ9."));
    }

    @Test
    public void toString_withResponseModeFormPostJwt_validHtmlFormResponse() throws CryptoProviderException {
        String expected = "<html><head><title>Submit This Form</title></head><body onload=\"javascript:document.forms[0].submit()\"><form method=\"post\" action=\"http://redirecturl.com/\"><input type=\"hidden\" name=\"response\" value=\"eyJraWQiOiJrZXkxMjMiLCJ0eXAiOiJKV1QiLCJhbGciOiJSUzI1NiJ9.eyJzY29wZSI6Im9wZW5pZCIsInJlc3BvbnNlX3R5cGUiOiJ0b2tlbiBpZF90b2tlbiIsInJlZGlyZWN0X3VyaSI6Imh0dHA6Ly9yZWRpcmVjdHVybC5jb20vIiwic3RhdGUiOiJjOTU1NzBkMS01YWI4LTQ2OGItOWMwMS05Y2M2MGUwMmIwMjMiLCJleHAiOiIxNjQ0MjcwNDczMzAxIiwibm9uY2UiOiIwZGEwZDA0Yi1hNmJkLTRkOWUtOGJkOS0yMTE2NWYwZDNiYjciLCJleHBpcmVzX2luIjoiMTY0NDI3MDQ3MzMwMSIsImNsaWVudF9pZCI6IjEyMyJ9.12345\"/></form></body></html>";
        RedirectUri redirectUri = this.getRedirectUriTemplateToString();
        redirectUri.setResponseMode(ResponseMode.FORM_POST_JWT);
        AbstractCryptoProvider cryptoProvider = (AbstractCryptoProvider)Mockito.mock(AbstractCryptoProvider.class);
        Mockito.when((Object)cryptoProvider.sign(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (SignatureAlgorithm)Mockito.any(SignatureAlgorithm.class))).thenReturn((Object)"12345");
        redirectUri.setCryptoProvider(cryptoProvider);
        redirectUri.setKeyId("key123");
        redirectUri.setSharedSecret("shared_secret");
        redirectUri.setNestedSharedSecret("nested_shared_secret");
        Assert.assertEquals((String)redirectUri.toString(), (String)expected);
    }

    @Test
    public void toString_withResponseModeFormPost_validHtmlFormResponse() {
        String valTestCase = "<html><head><title>Submit This Form</title></head><body onload=\"javascript:document.forms[0].submit()\"><form method=\"post\" action=\"http://redirecturl.com/\"><input type=\"hidden\" name=\"scope\" value=\"openid\"/><input type=\"hidden\" name=\"response_type\" value=\"token id_token\"/><input type=\"hidden\" name=\"redirect_uri\" value=\"http://redirecturl.com/\"/><input type=\"hidden\" name=\"state\" value=\"c95570d1-5ab8-468b-9c01-9cc60e02b023\"/><input type=\"hidden\" name=\"nonce\" value=\"0da0d04b-a6bd-4d9e-8bd9-21165f0d3bb7\"/><input type=\"hidden\" name=\"expires_in\" value=\"1644270473301\"/><input type=\"hidden\" name=\"client_id\" value=\"123\"/></form></body></html>";
        RedirectUri redirectUri = this.getRedirectUriTemplateToString();
        redirectUri.setResponseMode(ResponseMode.FORM_POST);
        Assert.assertEquals((String)redirectUri.toString(), (String)valTestCase);
    }

    @Test
    public void toString_withResponseModeFragment_validURLFragmentString() {
        String valTestCase = "http://redirecturl.com/#scope=openid&response_type=token+id_token&redirect_uri=http%3A%2F%2Fredirecturl.com%2F&state=c95570d1-5ab8-468b-9c01-9cc60e02b023&nonce=0da0d04b-a6bd-4d9e-8bd9-21165f0d3bb7&expires_in=1644270473301&client_id=123";
        RedirectUri redirectUri = this.getRedirectUriTemplateToString();
        redirectUri.setResponseMode(ResponseMode.FRAGMENT);
        Assert.assertEquals((String)redirectUri.toString(), (String)valTestCase);
    }

    @Test
    public void toString_withResponseModeQuery_validURLQueryString() {
        String valTestCase = "http://redirecturl.com/?scope=openid&response_type=token+id_token&redirect_uri=http%3A%2F%2Fredirecturl.com%2F&state=c95570d1-5ab8-468b-9c01-9cc60e02b023&nonce=0da0d04b-a6bd-4d9e-8bd9-21165f0d3bb7&expires_in=1644270473301&client_id=123";
        RedirectUri redirectUri = this.getRedirectUriTemplateToString();
        redirectUri.setResponseMode(ResponseMode.QUERY);
        Assert.assertEquals((String)redirectUri.toString(), (String)valTestCase);
    }

    @Test
    public void toString_withResponseModeJwtAndresponseTypeToken_validURLFragmentString() throws CryptoProviderException {
        String expected = "http://redirecturl.com/#response=eyJraWQiOiJrZXkxMjMiLCJ0eXAiOiJKV1QiLCJhbGciOiJSUzI1NiJ9.eyJleHAiOiIxNjQ0MjcwNDczMzAxIiwiZXhwaXJlc19pbiI6IjE2NDQyNzA0NzMzMDEiLCJjbGllbnRfaWQiOiIxMjMifQ.12345";
        ArrayList<ResponseType> typeList = new ArrayList<ResponseType>();
        typeList.add(ResponseType.TOKEN);
        RedirectUri redirectUri = new RedirectUri("http://redirecturl.com/", typeList, ResponseMode.JWT);
        redirectUri.addResponseParameter("client_id", "123");
        redirectUri.addResponseParameter("expires_in", "1644270473301");
        redirectUri.setKeyId("key123");
        redirectUri.setSharedSecret("shared_secret");
        redirectUri.setNestedSharedSecret("nested_shared_secret");
        AbstractCryptoProvider cryptoProvider = (AbstractCryptoProvider)Mockito.mock(AbstractCryptoProvider.class);
        Mockito.when((Object)cryptoProvider.sign(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (SignatureAlgorithm)Mockito.any(SignatureAlgorithm.class))).thenReturn((Object)"12345");
        redirectUri.setCryptoProvider(cryptoProvider);
        Assert.assertEquals((String)redirectUri.toString(), (String)expected);
    }

    @Test
    public void toString_withResponseModeJwtAndresponseTypeCode_validURLQueryString() throws CryptoProviderException {
        String expected = "http://redirecturl.com/?response=eyJraWQiOiJrZXkxMjMiLCJ0eXAiOiJKV1QiLCJhbGciOiJSUzI1NiJ9.eyJleHAiOiIxNjQ0MjcwNDczMzAxIiwiZXhwaXJlc19pbiI6IjE2NDQyNzA0NzMzMDEiLCJjbGllbnRfaWQiOiIxMjMifQ.12345";
        ArrayList<ResponseType> typeList = new ArrayList<ResponseType>();
        typeList.add(ResponseType.CODE);
        RedirectUri redirectUri = new RedirectUri("http://redirecturl.com/", typeList, ResponseMode.JWT);
        redirectUri.setKeyId("key123");
        redirectUri.setSharedSecret("shared_secret");
        redirectUri.addResponseParameter("client_id", "123");
        redirectUri.addResponseParameter("expires_in", "1644270473301");
        AbstractCryptoProvider cryptoProvider = (AbstractCryptoProvider)Mockito.mock(AbstractCryptoProvider.class);
        Mockito.when((Object)cryptoProvider.sign(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (SignatureAlgorithm)Mockito.any(SignatureAlgorithm.class))).thenReturn((Object)"12345");
        redirectUri.setCryptoProvider(cryptoProvider);
        Assert.assertEquals((String)redirectUri.toString(), (String)expected);
    }

    @Test
    public void toString_nullResponseModeResponseTypeToken_validURLFragmentString() {
        String valTestCase = "http://redirecturl.com/#expires_in=1644270473301&client_id=123";
        ArrayList<ResponseType> typeList = new ArrayList<ResponseType>();
        typeList.add(ResponseType.TOKEN);
        RedirectUri redirectUri = new RedirectUri("http://redirecturl.com/", typeList, null);
        redirectUri.addResponseParameter("client_id", "123");
        redirectUri.addResponseParameter("expires_in", "1644270473301");
        Assert.assertEquals((String)redirectUri.toString(), (String)valTestCase);
    }

    @Test
    public void toString_nullResponseModeNoResponseType_validURLQueryString() {
        String valTestCase = "http://redirecturl.com/?expires_in=1644270473301&client_id=123";
        RedirectUri redirectUri = new RedirectUri("http://redirecturl.com/", null, null);
        redirectUri.addResponseParameter("client_id", "123");
        redirectUri.addResponseParameter("expires_in", "1644270473301");
        Assert.assertEquals((String)redirectUri.toString(), (String)valTestCase);
    }

    @Test
    public void toString_NoResponseParams_sameBaseUri() {
        String baseUri = "http://redirecturl.com/";
        RedirectUri redirectUri = new RedirectUri(baseUri);
        Assert.assertEquals((String)redirectUri.toString(), (String)baseUri);
    }

    private RedirectUri getRedirectUriTemplateToString() {
        String clientId = "123";
        String responseType = "token id_token";
        String scope = "openid";
        String state = "c95570d1-5ab8-468b-9c01-9cc60e02b023";
        String nonce = "0da0d04b-a6bd-4d9e-8bd9-21165f0d3bb7";
        RedirectUri redirectUri = (RedirectUri)Mockito.spy((Object)new RedirectUri("http://redirecturl.com/"));
        redirectUri.addResponseParameter("client_id", clientId);
        redirectUri.addResponseParameter("redirect_uri", redirectUri.getBaseRedirectUri());
        redirectUri.addResponseParameter("response_type", responseType);
        redirectUri.addResponseParameter("scope", scope);
        redirectUri.addResponseParameter("state", state);
        redirectUri.addResponseParameter("nonce", nonce);
        redirectUri.addResponseParameter("expires_in", "1644270473301");
        redirectUri.setAuthorizationCodeLifetime(1000);
        redirectUri.setBlockEncryptionAlgorithm(null);
        redirectUri.setNestedKeyId("nki");
        redirectUri.setResponseMode(null);
        return redirectUri;
    }

    private RedirectUri getRedirectUriTemplateGetQueryString(ResponseMode responseMode, KeyEncryptionAlgorithm keyEncryptionAlgorithm, BlockEncryptionAlgorithm blockEncryptionAlgorithm, SignatureAlgorithm signatureAlgorithm) {
        RedirectUri redirectUri = (RedirectUri)Mockito.spy((Object)new RedirectUri("http://redirecturl.com/", new ArrayList(), responseMode));
        redirectUri.setKeyEncryptionAlgorithm(keyEncryptionAlgorithm);
        redirectUri.setBlockEncryptionAlgorithm(blockEncryptionAlgorithm);
        redirectUri.setSignatureAlgorithm(signatureAlgorithm);
        redirectUri.setIssuer("user123");
        redirectUri.setKeyId("key123");
        redirectUri.setSharedSecret("shared_secret");
        redirectUri.setJsonWebKeys(null);
        return redirectUri;
    }

    private void assertNoEmptyQueryString(String queryResult, String paramToVerify, int paramsSize) throws UnsupportedEncodingException {
        Assert.assertTrue((queryResult.length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)queryResult.contains(URLEncoder.encode(paramToVerify, "UTF-8")));
        RedirectUri redirectUri2 = this.getRedirectUriTemplateGetQueryString(null, null, null, null);
        redirectUri2.parseQueryString(queryResult);
        Assert.assertEquals((int)redirectUri2.getResponseParamentersSize(), (int)paramsSize);
    }

    private String encodeUTF8(String input) throws UnsupportedEncodingException {
        return URLEncoder.encode(input, "UTF-8");
    }

    private RSAPublicKey getRSAPublicKey() throws NoSuchAlgorithmException, InvalidKeySpecException {
        String modulus = "00e0b509f6259df8642dbc35662901477df22677ec152b5ff68ace615bb7b725152b3ab17a876aea8a5aa76d2e417629ec4ee341f56135fccf695280104e0312ecbda92557c93870114af6c9d05c4f7f0c3685b7a46bee255932575cce10b424d813cfe4875d3e82047b97ddef52741d546b8e289dc6935b3ece0462db0a22b8e7";
        String publicExponent = "010001";
        RSAPublicKeySpec rsaPubKS = new RSAPublicKeySpec(new BigInteger(modulus, 16), new BigInteger(publicExponent, 16));
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return (RSAPublicKey)keyFactory.generatePublic(rsaPubKS);
    }
}

