/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.common.cert.validation;

import io.jans.as.common.cert.validation.CertificateVerifier;
import io.jans.as.common.cert.validation.model.ValidationStatus;
import io.jans.util.security.SecurityProviderUtility;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathValidator;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathCertificateVerifier
implements CertificateVerifier {
    private static final Logger log = LoggerFactory.getLogger(PathCertificateVerifier.class);
    private final boolean verifySelfSignedCertificate;

    public PathCertificateVerifier(boolean verifySelfSignedCert) {
        SecurityProviderUtility.installBCProvider((boolean)true);
        this.verifySelfSignedCertificate = verifySelfSignedCert;
    }

    public static boolean isSelfSigned(X509Certificate certificate) throws CertificateException, NoSuchAlgorithmException, NoSuchProviderException {
        try {
            PublicKey key = certificate.getPublicKey();
            certificate.verify(key);
            return true;
        }
        catch (InvalidKeyException | SignatureException ex) {
            return false;
        }
    }

    @Override
    public ValidationStatus validate(X509Certificate certificate, List<X509Certificate> issuers, Date validationDate) {
        X509Certificate issuer = issuers.get(0);
        ValidationStatus status = new ValidationStatus(certificate, issuer, validationDate, ValidationStatus.ValidatorSourceType.CHAIN, ValidationStatus.CertificateValidity.UNKNOWN);
        try {
            ArrayList<X509Certificate> chains = new ArrayList<X509Certificate>();
            chains.add(certificate);
            chains.addAll(issuers);
            X500Principal subjectX500Principal = certificate.getSubjectX500Principal();
            PKIXCertPathBuilderResult certPathResult = this.verifyCertificate(certificate, chains);
            if (certPathResult == null) {
                log.warn("Chain status is not valid for '" + subjectX500Principal + "'");
                status.setValidity(ValidationStatus.CertificateValidity.INVALID);
                return status;
            }
            log.debug("Chain status is valid for '" + subjectX500Principal + "'");
            status.setValidity(ValidationStatus.CertificateValidity.VALID);
        }
        catch (Exception ex) {
            log.error("OCSP exception: ", (Throwable)ex);
        }
        return status;
    }

    public PKIXCertPathBuilderResult verifyCertificate(X509Certificate certificate, List<X509Certificate> additionalCerts) {
        try {
            if (!this.verifySelfSignedCertificate && PathCertificateVerifier.isSelfSigned(certificate)) {
                log.error("The certificate is self-signed!");
                return null;
            }
            HashSet<X509Certificate> trustedRootCerts = new HashSet<X509Certificate>();
            HashSet<X509Certificate> intermediateCerts = new HashSet<X509Certificate>();
            for (X509Certificate additionalCert : additionalCerts) {
                if (PathCertificateVerifier.isSelfSigned(additionalCert)) {
                    trustedRootCerts.add(additionalCert);
                    continue;
                }
                intermediateCerts.add(additionalCert);
            }
            PKIXCertPathBuilderResult certPathBuilderResult = this.verifyCertificate(certificate, trustedRootCerts, intermediateCerts);
            CertPath certPath = certPathBuilderResult.getCertPath();
            List<? extends Certificate> certList = certPath.getCertificates();
            X509Certificate cert = (X509Certificate)certList.get(0);
            if (cert.getBasicConstraints() != -1) {
                log.error("Target certificate is not an EE certificate!");
                return null;
            }
            return certPathBuilderResult;
        }
        catch (GeneralSecurityException ex) {
            log.error("Failed to build certificate path", (Throwable)ex);
            return null;
        }
    }

    private PKIXCertPathBuilderResult verifyCertificate(X509Certificate certificate, Set<X509Certificate> trustedRootCerts, Set<X509Certificate> intermediateCerts) throws GeneralSecurityException {
        X509CertSelector selector = new X509CertSelector();
        selector.setBasicConstraints(-2);
        selector.setCertificate(certificate);
        HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
        for (X509Certificate trustedRootCert : trustedRootCerts) {
            trustAnchors.add(new TrustAnchor(trustedRootCert, null));
        }
        PKIXBuilderParameters pkixParams = new PKIXBuilderParameters(trustAnchors, (CertSelector)selector);
        pkixParams.setRevocationEnabled(false);
        CertStore intermediateCertStore = CertStore.getInstance("Collection", new CollectionCertStoreParameters(intermediateCerts));
        pkixParams.addCertStore(intermediateCertStore);
        CertPathBuilder builder = CertPathBuilder.getInstance("PKIX", SecurityProviderUtility.getBCProvider());
        PKIXCertPathBuilderResult certPathBuilderResult = (PKIXCertPathBuilderResult)builder.build(pkixParams);
        CertPathValidator certPathValidator = CertPathValidator.getInstance("PKIX", SecurityProviderUtility.getBCProvider());
        certPathValidator.validate(certPathBuilderResult.getCertPath(), pkixParams);
        return certPathBuilderResult;
    }

    @Override
    public void destroy() {
    }
}

