/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.common.service;

import io.jans.as.persistence.model.GluuOrganization;
import io.jans.orm.PersistenceEntryManager;
import io.jans.service.BaseCacheService;
import io.jans.service.CacheService;
import io.jans.service.LocalCacheService;
import jakarta.inject.Inject;

public abstract class OrganizationService
extends io.jans.service.OrganizationService {
    public static final int ONE_MINUTE_IN_SECONDS = 60;
    private static final long serialVersionUID = -8966940469789981584L;
    @Inject
    private PersistenceEntryManager ldapEntryManager;
    @Inject
    private CacheService cacheService;
    @Inject
    private LocalCacheService localCacheService;

    public void updateOrganization(GluuOrganization organization) {
        this.ldapEntryManager.merge((Object)organization);
    }

    public GluuOrganization getOrganization() {
        BaseCacheService usedCacheService = this.getCacheService();
        return (GluuOrganization)usedCacheService.getWithPut("organization_jans", () -> (GluuOrganization)this.ldapEntryManager.find(GluuOrganization.class, (Object)this.getDnForOrganization()), 60);
    }

    public String getDnForOrganization() {
        return this.getBaseDn();
    }

    private BaseCacheService getCacheService() {
        if (this.isUseLocalCache()) {
            return this.localCacheService;
        }
        return this.cacheService;
    }

    protected abstract boolean isUseLocalCache();
}

