/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.common.service.common;

import io.jans.as.model.config.StaticConfiguration;
import io.jans.config.GluuConfiguration;
import io.jans.model.SmtpConfiguration;
import io.jans.orm.PersistenceEntryManager;
import io.jans.service.EncryptionService;
import io.jans.util.StringHelper;
import io.jans.util.security.StringEncrypter;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import org.slf4j.Logger;

@ApplicationScoped
public class ConfigurationService {
    @Inject
    private Logger log;
    @Inject
    private PersistenceEntryManager persistenceEntryManager;
    @Inject
    private StaticConfiguration staticConfiguration;
    @Inject
    private EncryptionService encryptionService;

    public void addConfiguration(GluuConfiguration configuration) {
        this.persistenceEntryManager.persist((Object)configuration);
    }

    public void updateConfiguration(GluuConfiguration configuration) {
        this.persistenceEntryManager.merge((Object)configuration);
    }

    public GluuConfiguration getConfigurationByInum(String inum) {
        return (GluuConfiguration)this.persistenceEntryManager.find(GluuConfiguration.class, (Object)this.getDnForConfiguration(inum));
    }

    public GluuConfiguration getConfiguration() {
        String configurationDn = this.staticConfiguration.getBaseDn().getConfiguration();
        if (StringHelper.isEmpty((String)configurationDn)) {
            return null;
        }
        return (GluuConfiguration)this.persistenceEntryManager.find(GluuConfiguration.class, (Object)configurationDn);
    }

    public String getDnForConfiguration(String inum) {
        String baseDn = this.staticConfiguration.getBaseDn().getConfiguration();
        if (StringHelper.isEmpty((String)inum)) {
            return baseDn;
        }
        return String.format("inum=%s,%s", inum, baseDn);
    }

    public void decryptSmtpPasswords(SmtpConfiguration smtpConfiguration) {
        if (smtpConfiguration == null) {
            return;
        }
        String password = smtpConfiguration.getSmtpAuthenticationAccountPassword();
        if (StringHelper.isNotEmpty((String)password)) {
            try {
                smtpConfiguration.setSmtpAuthenticationAccountPasswordDecrypted(this.encryptionService.decrypt(password));
            }
            catch (StringEncrypter.EncryptionException ex) {
                this.log.error("Failed to decrypt SMTP user password", (Throwable)ex);
            }
        }
        if (StringHelper.isNotEmpty((String)(password = smtpConfiguration.getKeyStorePassword()))) {
            try {
                smtpConfiguration.setKeyStorePasswordDecrypted(this.encryptionService.decrypt(password));
            }
            catch (StringEncrypter.EncryptionException ex) {
                this.log.error("Failed to decrypt Kestore password", (Throwable)ex);
            }
        }
    }
}

