/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.common.service.common;

import io.jans.as.common.service.common.ExternalIdGeneratorService;
import io.jans.as.model.common.IdType;
import io.jans.as.model.util.Pair;
import io.jans.util.StringHelper;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.UUID;
import org.slf4j.Logger;

@ApplicationScoped
public class InumService {
    public static final int MAX_IDGEN_TRY_COUNT = 10;
    @Inject
    private Logger log;
    @Inject
    private ExternalIdGeneratorService externalIdGenerationService;

    public String generateClientInum() {
        return this.generateId(IdType.CLIENTS.getType());
    }

    public String generatePeopleInum() {
        return this.generateId(IdType.PEOPLE.getType());
    }

    public String generateInum() {
        return this.generateClientInum();
    }

    public Pair<String, String> generateNewDN(String baseDn) {
        String inum = this.generateInum();
        StringBuilder dnSb = new StringBuilder("inum=");
        dnSb.append(inum).append(",").append(baseDn);
        String dn = dnSb.toString();
        this.log.trace("Generated dn: {}", (Object)dn);
        return new Pair((Object)inum, (Object)dn);
    }

    public String generateId(String idType) {
        String generatedId;
        if (this.externalIdGenerationService.isEnabled() && StringHelper.isNotEmpty((String)(generatedId = this.externalIdGenerationService.executeExternalDefaultGenerateIdMethod("jans-auth", idType, "")))) {
            return generatedId;
        }
        return this.generateDefaultId();
    }

    public String generateDefaultId() {
        return UUID.randomUUID().toString();
    }
}

