/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.common.model.session;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.jans.as.common.model.common.User;
import io.jans.as.common.model.session.SessionIdAccessMap;
import io.jans.as.common.model.session.SessionIdState;
import io.jans.as.model.util.StringUtils;
import io.jans.orm.annotation.AttributeName;
import io.jans.orm.annotation.DN;
import io.jans.orm.annotation.DataEntry;
import io.jans.orm.annotation.Expiration;
import io.jans.orm.annotation.JsonObject;
import io.jans.orm.annotation.ObjectClass;
import io.jans.orm.model.base.Deletable;
import jakarta.inject.Named;
import jakarta.persistence.Transient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.BooleanUtils;
import org.jetbrains.annotations.NotNull;

@Named(value="sessionUser")
@DataEntry
@ObjectClass(value="jansSessId")
public class SessionId
implements Deletable,
Serializable {
    public static final String OLD_SESSION_ID_ATTR_KEY = "old_session_id";
    public static final String OP_BROWSER_STATE = "opbs";
    private static final long serialVersionUID = -237476411915686378L;
    @DN
    private String dn;
    @AttributeName(name="jansId")
    private String id;
    @AttributeName(name="sid")
    private String outsideSid;
    @AttributeName(name="jansLastAccessTime")
    private Date lastUsedAt;
    @AttributeName(name="jansUsrDN")
    private String userDn;
    @AttributeName(name="authnTime")
    private Date authenticationTime;
    @AttributeName(name="jansState")
    private SessionIdState state;
    @AttributeName(name="jansSessState")
    private String sessionState;
    @AttributeName(name="jansPermissionGranted")
    private Boolean permissionGranted;
    @JsonObject
    @AttributeName(name="jansPermissionGrantedMap")
    private SessionIdAccessMap permissionGrantedMap;
    @JsonObject
    @AttributeName(name="jansSessAttr")
    private Map<String, String> sessionAttributes;
    @AttributeName(name="deviceSecret")
    private List<String> deviceSecrets;
    @AttributeName(name="exp")
    private Date expirationDate;
    @AttributeName(name="del")
    private Boolean deletable = true;
    @AttributeName(name="creationDate")
    private Date creationDate = new Date();
    @Transient
    private transient boolean persisted;
    @Transient
    private User user;
    @Expiration
    private int ttl;

    @NotNull
    public List<String> getDeviceSecrets() {
        if (this.deviceSecrets == null) {
            this.deviceSecrets = new ArrayList<String>();
        }
        return this.deviceSecrets;
    }

    public void setDeviceSecrets(List<String> deviceSecrets) {
        this.deviceSecrets = deviceSecrets;
    }

    public int getTtl() {
        return this.ttl;
    }

    public void setTtl(int ttl) {
        this.ttl = ttl;
    }

    public String getDn() {
        return this.dn;
    }

    public void setDn(String dn) {
        this.dn = dn;
    }

    public SessionIdState getState() {
        return this.state;
    }

    public void setState(SessionIdState state) {
        this.state = state;
    }

    public String getSessionState() {
        return this.sessionState;
    }

    public void setSessionState(String sessionState) {
        this.sessionState = sessionState;
    }

    public String getOPBrowserState() {
        return this.sessionAttributes.get(OP_BROWSER_STATE);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Date getLastUsedAt() {
        return this.lastUsedAt;
    }

    public void setLastUsedAt(Date lastUsedAt) {
        this.lastUsedAt = lastUsedAt;
    }

    public String getUserDn() {
        return this.userDn;
    }

    public void setUserDn(String userDn) {
        this.userDn = userDn != null ? userDn : "";
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Date getAuthenticationTime() {
        return this.authenticationTime;
    }

    public void setAuthenticationTime(Date authenticationTime) {
        this.authenticationTime = authenticationTime;
    }

    public Boolean getPermissionGranted() {
        return this.permissionGranted;
    }

    public void setPermissionGranted(Boolean permissionGranted) {
        this.permissionGranted = permissionGranted;
    }

    public SessionIdAccessMap getPermissionGrantedMap() {
        if (this.permissionGrantedMap == null) {
            this.permissionGrantedMap = new SessionIdAccessMap();
        }
        return this.permissionGrantedMap;
    }

    public void setPermissionGrantedMap(SessionIdAccessMap permissionGrantedMap) {
        this.permissionGrantedMap = permissionGrantedMap;
    }

    public Boolean isPermissionGrantedForClient(String clientId) {
        return this.permissionGrantedMap != null && this.permissionGrantedMap.get(clientId) != false;
    }

    public void addPermission(String clientId, Boolean granted) {
        this.addPermission(clientId, granted, null);
    }

    public void addPermission(String clientId, Boolean granted, Set<String> scopes) {
        if (this.permissionGrantedMap == null) {
            this.permissionGrantedMap = new SessionIdAccessMap();
        }
        this.maintainClientScopes(BooleanUtils.isTrue((Boolean)granted), clientId, scopes);
        this.permissionGrantedMap.put(clientId, granted);
    }

    private void maintainClientScopes(boolean granted, String clientId, Set<String> scopes) {
        String key = clientId + "_authz_scopes";
        if (!granted) {
            this.getSessionAttributes().remove(key);
            return;
        }
        if (scopes != null && !scopes.isEmpty()) {
            String existingScopes = this.getSessionAttributes().get(key);
            HashSet resultScopes = Sets.newHashSet(scopes);
            resultScopes.addAll(StringUtils.spaceSeparatedToList((String)existingScopes));
            this.getSessionAttributes().put(key, StringUtils.implode((Collection)resultScopes, (String)" "));
        }
    }

    @NotNull
    public Map<String, String> getSessionAttributes() {
        if (this.sessionAttributes == null) {
            this.sessionAttributes = Maps.newHashMap();
        }
        return this.sessionAttributes;
    }

    public void setSessionAttributes(Map<String, String> sessionAttributes) {
        this.sessionAttributes = sessionAttributes;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public Boolean isDeletable() {
        return this.deletable != null ? this.deletable : true;
    }

    public void setDeletable(Boolean deletable) {
        this.deletable = deletable;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public void setOutsideSid(String outsideSid) {
        this.outsideSid = outsideSid;
    }

    public String getOutsideSid() {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.outsideSid)) {
            this.outsideSid = UUID.randomUUID().toString();
        }
        return this.outsideSid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionId id1 = (SessionId)o;
        return !(this.id == null ? id1.id != null : !this.id.equals(id1.id));
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SessionId {");
        sb.append("dn='").append(this.dn).append('\'');
        sb.append(", id='").append(this.id).append('\'');
        sb.append(", outsideSid='").append(this.outsideSid).append('\'');
        sb.append(", lastUsedAt=").append(this.lastUsedAt);
        sb.append(", userDn='").append(this.userDn).append('\'');
        sb.append(", authenticationTime=").append(this.authenticationTime);
        sb.append(", state=").append((Object)this.state);
        sb.append(", expirationDate=").append(this.expirationDate);
        sb.append(", sessionState='").append(this.sessionState).append('\'');
        sb.append(", permissionGranted=").append(this.permissionGranted);
        sb.append(", permissionGrantedMap=").append(this.permissionGrantedMap);
        sb.append(", sessionAttributes=").append(this.sessionAttributes);
        sb.append(", persisted=").append(this.persisted);
        sb.append(", deviceSecrets=").append(this.deviceSecrets);
        sb.append("}");
        return sb.toString();
    }
}

