/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.common.service.common;

import io.jans.as.common.service.common.ConfigurationService;
import io.jans.as.model.config.StaticConfiguration;
import io.jans.config.GluuConfiguration;
import io.jans.model.SmtpConfiguration;
import io.jans.orm.PersistenceEntryManagerFactory;
import io.jans.orm.model.PersistenceConfiguration;
import io.jans.orm.service.PersistanceFactoryService;
import io.jans.service.cache.CacheConfiguration;
import io.jans.service.cache.InMemoryConfiguration;
import io.jans.service.document.store.conf.DocumentStoreConfiguration;
import io.jans.service.document.store.conf.LocalDocumentStoreConfiguration;
import io.jans.service.message.model.config.MessageConfiguration;
import io.jans.service.message.model.config.MessageProviderType;
import io.jans.service.message.model.config.NullMessageConfiguration;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@ApplicationScoped
public class ApplicationFactory {
    public static final String PERSISTENCE_AUTH_CONFIG_NAME = "persistenceAuthConfig";
    public static final String PERSISTENCE_ENTRY_MANAGER_NAME = "persistenceEntryManager";
    public static final String PERSISTENCE_METRIC_ENTRY_MANAGER_NAME = "persistenceMetricEntryManager";
    public static final String PERSISTENCE_AUTH_ENTRY_MANAGER_NAME = "persistenceAuthEntryManager";
    public static final String PERSISTENCE_METRIC_CONFIG_GROUP_NAME = "metric";
    @Inject
    private Logger log;
    @Inject
    private ConfigurationService configurationService;
    @Inject
    private PersistanceFactoryService persistanceFactoryService;
    @Inject
    private PersistenceConfiguration persistenceConfiguration;
    @Inject
    private StaticConfiguration staticConfiguration;

    @Produces
    @ApplicationScoped
    public CacheConfiguration getCacheConfiguration() {
        CacheConfiguration cacheConfiguration = this.configurationService.getConfiguration().getCacheConfiguration();
        if (cacheConfiguration == null || cacheConfiguration.getCacheProviderType() == null) {
            this.log.error("Failed to read cache configuration from DB. Please check configuration jsCacheConf attribute that must contain cache configuration JSON represented by CacheConfiguration.class. Appliance DN: " + this.configurationService.getConfiguration().getDn());
            this.log.info("Creating fallback IN-MEMORY cache configuration ... ");
            cacheConfiguration = new CacheConfiguration();
            cacheConfiguration.setInMemoryConfiguration(new InMemoryConfiguration());
            this.log.info("IN-MEMORY cache configuration is created.");
        }
        if (cacheConfiguration.getNativePersistenceConfiguration() != null && !StringUtils.isEmpty((CharSequence)this.staticConfiguration.getBaseDn().getSessions())) {
            cacheConfiguration.getNativePersistenceConfiguration().setBaseDn(StringUtils.remove((String)this.staticConfiguration.getBaseDn().getSessions(), (String)"ou=sessions,").trim());
        }
        this.log.info("Cache configuration: " + cacheConfiguration);
        return cacheConfiguration;
    }

    @Produces
    @ApplicationScoped
    public MessageConfiguration getMessageConfiguration() {
        MessageConfiguration messageConfiguration = this.configurationService.getConfiguration().getMessageConfiguration();
        if (messageConfiguration == null || messageConfiguration.getMessageProviderType() == null) {
            this.log.error("Failed to read message configuration from DB. Please check configuration jsMessageConf attribute that must contain message configuration JSON represented by MessageConfiguration.class. Appliance DN: " + this.configurationService.getConfiguration().getDn());
            this.log.info("Creating fallback Null message configuration ... ");
            messageConfiguration = new MessageConfiguration();
            messageConfiguration.setMessageProviderType(MessageProviderType.DISABLED);
            messageConfiguration.setNullConfiguration(new NullMessageConfiguration());
            this.log.info("NULL message configuration is created.");
        }
        this.log.info("Message configuration: " + messageConfiguration);
        return messageConfiguration;
    }

    @Produces
    @ApplicationScoped
    public DocumentStoreConfiguration getDocumentStoreConfiguration() {
        DocumentStoreConfiguration documentStoreConfiguration = this.configurationService.getConfiguration().getDocumentStoreConfiguration();
        if (documentStoreConfiguration == null || documentStoreConfiguration.getDocumentStoreType() == null) {
            this.log.error("Failed to read document store configuration from DB. Please check configuration jsDocStoreConf attribute that must contain document store configuration JSON represented by DocumentStoreConfiguration.class. Appliance DN: " + this.configurationService.getConfiguration().getDn());
            this.log.info("Creating fallback LOCAL document store configuration ... ");
            documentStoreConfiguration = new DocumentStoreConfiguration();
            documentStoreConfiguration.setLocalConfiguration(new LocalDocumentStoreConfiguration());
            this.log.info("LOCAL document store configuration is created.");
        }
        this.log.info("Document store configuration: " + documentStoreConfiguration);
        return documentStoreConfiguration;
    }

    @Produces
    @RequestScoped
    public SmtpConfiguration getSmtpConfiguration() {
        GluuConfiguration configuration = this.configurationService.getConfiguration();
        SmtpConfiguration smtpConfiguration = configuration.getSmtpConfiguration();
        if (smtpConfiguration == null) {
            return new SmtpConfiguration();
        }
        this.configurationService.decryptSmtpPasswords(smtpConfiguration);
        return smtpConfiguration;
    }

    public PersistenceEntryManagerFactory getPersistenceEntryManagerFactory() {
        return this.persistanceFactoryService.getPersistenceEntryManagerFactory(this.persistenceConfiguration);
    }

    public PersistenceEntryManagerFactory getPersistenceEntryManagerFactory(Class<? extends PersistenceEntryManagerFactory> persistenceEntryManagerFactoryClass) {
        return this.persistanceFactoryService.getPersistenceEntryManagerFactory(persistenceEntryManagerFactoryClass);
    }
}

