/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.common.util;

import io.jans.as.model.common.ResponseMode;
import io.jans.as.model.common.ResponseType;
import io.jans.as.model.crypto.AbstractCryptoProvider;
import io.jans.as.model.crypto.encryption.BlockEncryptionAlgorithm;
import io.jans.as.model.crypto.encryption.KeyEncryptionAlgorithm;
import io.jans.as.model.crypto.signature.SignatureAlgorithm;
import io.jans.as.model.exception.CryptoProviderException;
import io.jans.as.model.exception.InvalidJweException;
import io.jans.as.model.exception.InvalidJwtException;
import io.jans.as.model.jwe.Jwe;
import io.jans.as.model.jwe.JweEncrypterImpl;
import io.jans.as.model.jwt.Jwt;
import io.jans.as.model.jwt.JwtType;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.PublicKey;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

public class RedirectUri {
    private String baseRedirectUri;
    private List<ResponseType> responseTypes;
    private ResponseMode responseMode;
    private final Map<String, String> responseParameters;
    private String issuer;
    private String audience;
    private int authorizationCodeLifetime;
    private SignatureAlgorithm signatureAlgorithm;
    private KeyEncryptionAlgorithm keyEncryptionAlgorithm;
    private BlockEncryptionAlgorithm blockEncryptionAlgorithm;
    private String keyId;
    private String nestedKeyId;
    private String sharedSecret;
    private JSONObject jsonWebKeys;
    private byte[] sharedSymmetricKey;
    private String nestedSharedSecret;
    private JSONObject nestedJsonWebKeys;
    private AbstractCryptoProvider cryptoProvider;

    public RedirectUri(String baseRedirectUri) {
        this.baseRedirectUri = baseRedirectUri;
        this.responseMode = ResponseMode.QUERY;
        this.responseParameters = new HashMap<String, String>();
    }

    public RedirectUri(String baseRedirectUri, List<ResponseType> responseTypes, ResponseMode responseMode) {
        this(baseRedirectUri);
        this.responseTypes = responseTypes;
        this.responseMode = responseMode;
    }

    public String getBaseRedirectUri() {
        return this.baseRedirectUri;
    }

    public void setBaseRedirectUri(String baseRedirectUri) {
        this.baseRedirectUri = baseRedirectUri;
    }

    public ResponseMode getResponseMode() {
        return this.responseMode;
    }

    public void setResponseMode(ResponseMode responseMode) {
        this.responseMode = responseMode;
    }

    public void addResponseParameter(String key, String value) {
        if (StringUtils.isNotBlank((CharSequence)key)) {
            this.responseParameters.put(key, value);
        }
    }

    public void addResponseParameterIfNotBlank(String key, String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            this.addResponseParameter(key, value);
        }
    }

    @Nullable
    public String getResponseParameter(@NotNull String key) {
        return this.responseParameters.get(key);
    }

    public int getResponseParamentersSize() {
        return this.responseParameters != null ? this.responseParameters.size() : 0;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public String getAudience() {
        return this.audience;
    }

    public void setAudience(String audience) {
        this.audience = audience;
    }

    public int getAuthorizationCodeLifetime() {
        return this.authorizationCodeLifetime;
    }

    public void setAuthorizationCodeLifetime(int authorizationCodeLifetime) {
        this.authorizationCodeLifetime = authorizationCodeLifetime;
    }

    public SignatureAlgorithm getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public void setSignatureAlgorithm(SignatureAlgorithm signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
    }

    public KeyEncryptionAlgorithm getKeyEncryptionAlgorithm() {
        return this.keyEncryptionAlgorithm;
    }

    public void setKeyEncryptionAlgorithm(KeyEncryptionAlgorithm keyEncryptionAlgorithm) {
        this.keyEncryptionAlgorithm = keyEncryptionAlgorithm;
    }

    public BlockEncryptionAlgorithm getBlockEncryptionAlgorithm() {
        return this.blockEncryptionAlgorithm;
    }

    public void setBlockEncryptionAlgorithm(BlockEncryptionAlgorithm blockEncryptionAlgorithm) {
        this.blockEncryptionAlgorithm = blockEncryptionAlgorithm;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    public String getNestedKeyId() {
        return this.nestedKeyId;
    }

    public void setNestedKeyId(String nestedKeyId) {
        this.nestedKeyId = nestedKeyId;
    }

    public String getSharedSecret() {
        return this.sharedSecret;
    }

    public void setSharedSecret(String sharedSecret) {
        this.sharedSecret = sharedSecret;
    }

    public JSONObject getJsonWebKeys() {
        return this.jsonWebKeys;
    }

    public void setJsonWebKeys(JSONObject jsonWebKeys) {
        this.jsonWebKeys = jsonWebKeys;
    }

    public byte[] getSharedSymmetricKey() {
        return this.sharedSymmetricKey;
    }

    public void setSharedSymmetricKey(byte[] sharedSymmetricKey) {
        this.sharedSymmetricKey = sharedSymmetricKey;
    }

    public String getNestedSharedSecret() {
        return this.nestedSharedSecret;
    }

    public void setNestedSharedSecret(String nestedSharedSecret) {
        this.nestedSharedSecret = nestedSharedSecret;
    }

    public JSONObject getNestedJsonWebKeys() {
        return this.nestedJsonWebKeys;
    }

    public void setNestedJsonWebKeys(JSONObject nestedJsonWebKeys) {
        this.nestedJsonWebKeys = nestedJsonWebKeys;
    }

    public AbstractCryptoProvider getCryptoProvider() {
        return this.cryptoProvider;
    }

    public void setCryptoProvider(AbstractCryptoProvider cryptoProvider) {
        this.cryptoProvider = cryptoProvider;
    }

    public void parseQueryString(String queryString) {
        if (queryString != null) {
            StringTokenizer st = new StringTokenizer(queryString, "&", false);
            while (st.hasMoreElements()) {
                String paramName;
                String nameValueToken = st.nextElement().toString();
                StringTokenizer stParamValue = new StringTokenizer(nameValueToken, "=", false);
                if (stParamValue.countTokens() == 1) {
                    paramName = stParamValue.nextElement().toString();
                    this.responseParameters.put(paramName, null);
                    continue;
                }
                if (stParamValue.countTokens() != 2) continue;
                try {
                    paramName = stParamValue.nextElement().toString();
                    String paramValue = URLDecoder.decode(stParamValue.nextElement().toString(), "UTF-8");
                    this.responseParameters.put(paramName, paramValue);
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public String getQueryString() {
        StringBuilder sb = new StringBuilder();
        try {
            if (this.responseMode == ResponseMode.JWT || this.responseMode == ResponseMode.QUERY_JWT || this.responseMode == ResponseMode.FRAGMENT_JWT) {
                String responseJwt = this.getJarmResponse();
                sb.append(URLEncoder.encode("response", "UTF-8"));
                sb.append('=').append(URLEncoder.encode(responseJwt, "UTF-8"));
            } else if (this.responseMode == ResponseMode.FORM_POST_JWT) {
                String responseJwt = this.getJarmResponse();
                sb.append(responseJwt);
            } else {
                for (Map.Entry<String, String> entry : this.responseParameters.entrySet()) {
                    if (!StringUtils.isNotBlank((CharSequence)entry.getKey()) || !StringUtils.isNotBlank((CharSequence)entry.getValue())) continue;
                    if (sb.length() > 0) {
                        sb.append('&');
                    }
                    sb.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
                    sb.append('=').append(URLEncoder.encode(entry.getValue(), "UTF-8"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    private String getJarmResponse() throws InvalidJweException, InvalidJwtException, CryptoProviderException {
        if (this.keyEncryptionAlgorithm != null && this.blockEncryptionAlgorithm != null) {
            if (this.signatureAlgorithm != null) {
                String jws = this.getJwsResponse(true);
                return this.getJweResponse(jws);
            }
            return this.getJweResponse(null);
        }
        if (this.signatureAlgorithm == null) {
            this.signatureAlgorithm = SignatureAlgorithm.RS256;
        }
        return this.getJwsResponse(false);
    }

    private String getJwsResponse(boolean nested) throws InvalidJwtException, CryptoProviderException {
        Jwt jwt = new Jwt();
        jwt.getHeader().setType(JwtType.JWT);
        jwt.getHeader().setAlgorithm(this.signatureAlgorithm);
        if (nested) {
            if (this.nestedKeyId != null) {
                jwt.getHeader().setKeyId(this.nestedKeyId);
            }
        } else if (this.keyId != null) {
            jwt.getHeader().setKeyId(this.keyId);
        }
        jwt.getClaims().setClaim("iss", this.issuer);
        jwt.getClaims().setClaim("aud", this.audience);
        if (this.responseParameters.containsKey("expires_in")) {
            jwt.getClaims().setClaim("exp", this.responseParameters.get("expires_in"));
        } else {
            Calendar calendar = Calendar.getInstance();
            calendar.add(13, this.authorizationCodeLifetime);
            jwt.getClaims().setClaim("exp", calendar.getTime());
        }
        for (Map.Entry entry : this.responseParameters.entrySet()) {
            jwt.getClaims().setClaim((String)entry.getKey(), (String)entry.getValue());
        }
        String signature = this.cryptoProvider.sign(jwt.getSigningInput(), jwt.getHeader().getKeyId(), nested ? this.nestedSharedSecret : this.sharedSecret, this.signatureAlgorithm);
        jwt.setEncodedSignature(signature);
        return jwt.toString();
    }

    private String getJweResponse(String nestedJws) throws InvalidJweException, InvalidJwtException, CryptoProviderException {
        Jwe jwe = new Jwe();
        jwe.getHeader().setType(JwtType.JWT);
        jwe.getHeader().setAlgorithm(this.keyEncryptionAlgorithm);
        jwe.getHeader().setEncryptionMethod(this.blockEncryptionAlgorithm);
        if (nestedJws == null) {
            jwe.getClaims().setClaim("iss", this.issuer);
            jwe.getClaims().setClaim("aud", this.audience);
            if (this.responseParameters.containsKey("expires_in")) {
                jwe.getClaims().setClaim("exp", this.responseParameters.get("expires_in"));
            } else {
                Calendar calendar = Calendar.getInstance();
                calendar.add(13, this.authorizationCodeLifetime);
                jwe.getClaims().setClaim("exp", calendar.getTime());
            }
            for (Map.Entry entry : this.responseParameters.entrySet()) {
                jwe.getClaims().setClaim((String)entry.getKey(), (String)entry.getValue());
            }
        } else {
            Jwt jwt = Jwt.parse((String)nestedJws);
            jwe.setSignedJWTPayload(jwt);
        }
        if (this.keyEncryptionAlgorithm == KeyEncryptionAlgorithm.RSA_OAEP || this.keyEncryptionAlgorithm == KeyEncryptionAlgorithm.RSA1_5) {
            PublicKey publicKey = this.cryptoProvider.getPublicKey(this.keyId, this.jsonWebKeys, null);
            if (publicKey == null) {
                throw new InvalidJweException("The public key is not valid");
            }
            JweEncrypterImpl jweEncrypterImpl = new JweEncrypterImpl(this.keyEncryptionAlgorithm, this.blockEncryptionAlgorithm, publicKey);
            jwe = jweEncrypterImpl.encrypt(jwe);
        } else if (this.keyEncryptionAlgorithm == KeyEncryptionAlgorithm.A128KW || this.keyEncryptionAlgorithm == KeyEncryptionAlgorithm.A256KW) {
            JweEncrypterImpl jweEncrypter = new JweEncrypterImpl(this.keyEncryptionAlgorithm, this.blockEncryptionAlgorithm, this.sharedSymmetricKey);
            jwe = jweEncrypter.encrypt(jwe);
        }
        return jwe.toString();
    }

    private void appendQuerySymbol(StringBuilder sb) {
        if (!sb.toString().contains("?")) {
            sb.append("?");
        } else {
            sb.append("&");
        }
    }

    private void appendFragmentSymbol(StringBuilder sb) {
        if (!sb.toString().contains("#")) {
            sb.append("#");
        } else {
            sb.append("&");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.baseRedirectUri);
        if (this.responseParameters.isEmpty()) {
            return sb.toString();
        }
        if (this.responseMode == ResponseMode.FORM_POST) {
            sb = new StringBuilder();
            sb.append("<html>");
            sb.append("<head><title>Submit This Form</title></head>");
            sb.append("<body onload=\"javascript:document.forms[0].submit()\">");
            sb.append("<form method=\"post\" action=\"").append(this.baseRedirectUri).append("\">");
            for (Map.Entry<String, String> entry : this.responseParameters.entrySet()) {
                String entryKey = StringEscapeUtils.escapeHtml4((String)entry.getKey());
                String entryValue = StringEscapeUtils.escapeHtml4((String)entry.getValue());
                sb.append("<input type=\"hidden\" name=\"").append(entryKey).append("\" value=\"").append(entryValue).append("\"/>");
            }
            sb.append("</form>");
            sb.append("</body>");
            sb.append("</html>");
        } else if (this.responseMode == ResponseMode.FORM_POST_JWT) {
            sb = new StringBuilder();
            sb.append("<html>");
            sb.append("<head><title>Submit This Form</title></head>");
            sb.append("<body onload=\"javascript:document.forms[0].submit()\">");
            sb.append("<form method=\"post\" action=\"").append(this.baseRedirectUri).append("\">");
            sb.append("<input type=\"hidden\" name=\"response\"").append(" value=\"").append(this.getQueryString()).append("\"/>");
            sb.append("</form>");
            sb.append("</body>");
            sb.append("</html>");
        } else if (this.responseMode == ResponseMode.QUERY || this.responseMode == ResponseMode.QUERY_JWT) {
            this.appendQuerySymbol(sb);
            sb.append(this.getQueryString());
        } else if (this.responseMode == ResponseMode.FRAGMENT || this.responseMode == ResponseMode.FRAGMENT_JWT) {
            this.appendFragmentSymbol(sb);
            sb.append(this.getQueryString());
        } else if (this.responseTypes != null && this.responseMode == ResponseMode.JWT) {
            if (this.responseTypes.contains(ResponseType.TOKEN)) {
                this.appendFragmentSymbol(sb);
            } else if (this.responseTypes.contains(ResponseType.CODE)) {
                this.appendQuerySymbol(sb);
            }
            sb.append(this.getQueryString());
        } else {
            this.appendDefaultToString(sb);
        }
        return sb.toString();
    }

    private void appendDefaultToString(StringBuilder sb) {
        if (this.responseMode == null) {
            if (this.responseTypes != null && (this.responseTypes.contains(ResponseType.TOKEN) || this.responseTypes.contains(ResponseType.ID_TOKEN))) {
                this.appendFragmentSymbol(sb);
            } else {
                this.appendQuerySymbol(sb);
            }
        }
        sb.append(this.getQueryString());
    }
}

