/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.crypto.signature;

import io.jans.as.model.crypto.PrivateKey;
import io.jans.as.model.crypto.signature.SignatureAlgorithm;
import io.jans.as.model.util.Base64Util;
import java.math.BigInteger;
import org.json.JSONException;
import org.json.JSONObject;

public class ECDSAPrivateKey
extends PrivateKey {
    private BigInteger d;

    public ECDSAPrivateKey(SignatureAlgorithm signatureAlgorithm, BigInteger d) {
        this.setSignatureAlgorithm(signatureAlgorithm);
        this.d = d;
    }

    public ECDSAPrivateKey(String d) {
        this.d = new BigInteger(1, Base64Util.base64urldecode(d));
    }

    public BigInteger getD() {
        return this.d;
    }

    public void setD(BigInteger d) {
        this.d = d;
    }

    @Override
    public JSONObject toJSONObject() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("n", JSONObject.NULL);
        jsonObject.put("e", JSONObject.NULL);
        jsonObject.put("d", (Object)Base64Util.base64urlencodeUnsignedBigInt(this.d));
        return jsonObject;
    }

    public String toString() {
        try {
            return this.toJSONObject().toString(4);
        }
        catch (Exception e) {
            return "";
        }
    }
}

