/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.crypto.signature;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum EllipticEdvardsCurve {
    P_256("P-256", "secp256r1", "1.2.840.10045.3.1.7"),
    P_256K("P-256K", "secp256k1", "1.3.132.0.10"),
    P_384("P-384", "secp384r1", "1.3.132.0.34"),
    P_521("P-521", "secp521r1", "1.3.132.0.35"),
    ED_25519("Ed25519", "Ed25519", "oid: 1.3.101.112"),
    ED_448("Ed448", "Ed448", "oid: 1.3.101.113");

    private final String name;
    private final String alias;
    private final String oid;

    private EllipticEdvardsCurve(String name, String alias, String oid) {
        this.name = name;
        this.alias = alias;
        this.oid = oid;
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getOid() {
        return this.oid;
    }

    @JsonCreator
    public static EllipticEdvardsCurve fromString(String param) {
        if (param != null) {
            for (EllipticEdvardsCurve ec : EllipticEdvardsCurve.values()) {
                if (!param.equalsIgnoreCase(ec.getName()) && !param.equalsIgnoreCase(ec.getAlias())) continue;
                return ec;
            }
        }
        return null;
    }

    @JsonValue
    public String toString() {
        return this.name;
    }
}

