/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.json;

import io.jans.as.model.json.PropertyDefinition;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonApplier {
    private static final Logger log = Logger.getLogger(JsonApplier.class);
    private static final JsonApplier APPLIER = new JsonApplier();

    private JsonApplier() {
    }

    public static JsonApplier getInstance() {
        return APPLIER;
    }

    public void apply(Object source, JSONObject target) {
        for (PropertyDefinition definition : PropertyDefinition.values()) {
            this.apply(source, target, definition);
        }
    }

    public void apply(Object source, Map<String, String> parameters) {
        for (PropertyDefinition definition : PropertyDefinition.values()) {
            this.apply(source, parameters, definition);
        }
    }

    private void apply(Object source, Map<String, String> target, PropertyDefinition property) {
        try {
            if (!this.isAllowed(source, target, property, source.getClass())) {
                return;
            }
            Object value = this.invokeReflectionGetter(source, property.getJavaTargetPropertyName());
            if (value == null) {
                return;
            }
            if (String.class.isAssignableFrom(property.getJavaType())) {
                target.put(property.getJsonName(), (String)value);
                return;
            }
            if (Collection.class.isAssignableFrom(property.getJavaType())) {
                Collection valueAsCollection = (Collection)value;
                target.put(property.getJsonName(), new JSONArray(valueAsCollection).toString());
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void apply(Object source, JSONObject target, PropertyDefinition property) {
        try {
            if (!this.isAllowed(source, target, property, source.getClass())) {
                return;
            }
            Object value = this.invokeReflectionGetter(source, property.getJavaTargetPropertyName());
            if (String.class.isAssignableFrom(property.getJavaType())) {
                target.put(property.getJsonName(), value);
                return;
            }
            if (Collection.class.isAssignableFrom(property.getJavaType())) {
                Collection valueAsCollection = (Collection)value;
                target.put(property.getJsonName(), valueAsCollection);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private boolean isAllowed(Object source, Object target, PropertyDefinition property, Class<?> ... clazzesToCheck) {
        if (source == null || target == null || property == null || clazzesToCheck == null || clazzesToCheck.length == 0) {
            return false;
        }
        try {
            Set<String> allowedClasses = property.getJavaTargetsClassNamesAsStrings();
            for (Class<?> clazzToCheck : clazzesToCheck) {
                if (!allowedClasses.contains(clazzToCheck.getName())) {
                    return false;
                }
                Field field = clazzToCheck.getDeclaredField(property.getJavaTargetPropertyName());
                Class<?> javaType = property.getJavaType();
                if (field.getType().isAssignableFrom(javaType)) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void apply(JSONObject source, Object target) {
        for (PropertyDefinition definition : PropertyDefinition.values()) {
            this.apply(source, target, definition);
        }
    }

    public void apply(JSONObject source, Object target, PropertyDefinition property) {
        try {
            if (!source.has(property.getJsonName())) {
                return;
            }
            if (!this.isAllowed(source, target, property, target.getClass())) {
                return;
            }
            Object valueToSet = null;
            if (String.class.isAssignableFrom(property.getJavaType())) {
                valueToSet = source.optString(property.getJsonName());
            }
            if (Collection.class.isAssignableFrom(property.getJavaType())) {
                JSONArray jsonArray = source.getJSONArray(property.getJsonName());
                valueToSet = jsonArray.toList();
            }
            this.invokeReflectionSetter(target, property.getJavaTargetPropertyName(), valueToSet);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void transfer(Object source, Object target) {
        for (PropertyDefinition definition : PropertyDefinition.values()) {
            this.transfer(source, target, definition);
        }
    }

    private void transfer(Object source, Object target, PropertyDefinition property) {
        try {
            if (!this.isAllowed(source, target, property, source.getClass(), target.getClass())) {
                return;
            }
            Object valueToSet = null;
            if (String.class.isAssignableFrom(property.getJavaType()) || Collection.class.isAssignableFrom(property.getJavaType())) {
                valueToSet = this.invokeReflectionGetter(source, property.getJavaTargetPropertyName());
            }
            if (valueToSet != null) {
                this.invokeReflectionSetter(target, property.getJavaTargetPropertyName(), valueToSet);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static List<String> getStringList(JSONArray jsonArray) {
        ArrayList<String> values = new ArrayList<String>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            String value = jsonArray.optString(i);
            if (value == null) continue;
            values.add(value);
        }
        return values;
    }

    public void invokeReflectionSetter(Object obj, String propertyName, Object variableValue) {
        try {
            PropertyDescriptor pd = new PropertyDescriptor(propertyName, obj.getClass());
            Method setter = pd.getWriteMethod();
            if (setter != null) {
                setter.invoke(obj, variableValue);
            } else {
                log.error((Object)String.format("Method Setter not found for class: %s property: %s", obj.getClass().getName(), propertyName));
            }
        }
        catch (IntrospectionException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            log.error((Object)String.format("Method Setter ERROR for class: %s property: %s", obj.getClass().getName(), propertyName), (Throwable)e);
        }
    }

    public Object invokeReflectionGetter(Object obj, String variableName) {
        try {
            PropertyDescriptor pd = new PropertyDescriptor(variableName, obj.getClass());
            Method getter = pd.getReadMethod();
            if (getter != null) {
                return getter.invoke(obj, new Object[0]);
            }
            log.error((Object)String.format("Method Getter not found for class: %s property: %s", obj.getClass().getName(), variableName));
        }
        catch (IntrospectionException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            log.error((Object)String.format("Method Getter ERROR for class: %s property: %s", obj.getClass().getName(), variableName), (Throwable)e);
        }
        return null;
    }
}

