/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class QueryBuilder {
    private static final Logger LOG = Logger.getLogger(QueryBuilder.class);
    private final StringBuilder builder;

    public QueryBuilder() {
        this(new StringBuilder());
    }

    public QueryBuilder(StringBuilder builder) {
        this.builder = builder;
    }

    public static QueryBuilder instance() {
        return new QueryBuilder();
    }

    public String build() {
        return this.builder.toString();
    }

    public StringBuilder getBuilder() {
        return this.builder;
    }

    public void appendIfNotNull(String key, Object value) {
        if (value != null) {
            this.append(key, value.toString());
        }
    }

    public void append(String key, String value) {
        try {
            if (StringUtils.isNotBlank((CharSequence)value)) {
                if (this.builder.length() > 0) {
                    this.appendAmpersand();
                }
                this.builder.append(key).append("=").append(URLEncoder.encode(value, "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            LOG.trace((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void appendAmpersand() {
        this.builder.append("&");
    }

    public String toString() {
        return this.build();
    }
}

