/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.jwt;

import com.google.common.collect.Lists;
import io.jans.as.model.jwt.JwtClaims;
import org.testng.Assert;
import org.testng.annotations.Test;

public class JwtClaimsTest {
    @Test
    public void setClaimObject_whenSetSameValue_shouldNotCreateDuplicate() {
        JwtClaims claims = new JwtClaims();
        claims.addAudience("client1");
        claims.setClaimObject("aud", (Object)"client1", false);
        Assert.assertEquals((Object)claims.getClaim("aud"), (Object)"client1");
    }

    @Test
    public void setClaimObject_whenSetDifferentValues_shouldCreateCorrectArray() {
        JwtClaims claims = new JwtClaims();
        claims.addAudience("client1");
        claims.setClaimObject("aud", (Object)"client2", false);
        Assert.assertEquals((Object)claims.getClaim("aud"), (Object)Lists.newArrayList((Object[])new String[]{"client1", "client2"}));
    }

    @Test
    public void setClaimObject_whenSetDifferentValue_shouldCreateCorrectArray() {
        JwtClaims claims = new JwtClaims();
        claims.addAudience("client1");
        claims.setClaimObject("aud", (Object)"client2", false);
        claims.setClaimObject("aud", (Object)"client3", false);
        Assert.assertEquals((Object)claims.getClaim("aud"), (Object)Lists.newArrayList((Object[])new String[]{"client1", "client2", "client3"}));
    }

    @Test
    public void setClaimObject_whenSetDifferentValueWithOverride_shouldOverrideValue() {
        JwtClaims claims = new JwtClaims();
        claims.addAudience("client1");
        claims.setClaimObject("aud", (Object)"client2", false);
        claims.setClaimObject("aud", (Object)"client3", true);
        Assert.assertEquals((Object)claims.getClaim("aud"), (Object)"client3");
    }
}

