/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.crypto.signature;

import io.jans.as.model.crypto.PrivateKey;
import io.jans.as.model.crypto.signature.SignatureAlgorithm;
import io.jans.as.model.util.Base64Util;
import java.math.BigInteger;
import org.json.JSONException;
import org.json.JSONObject;

public class RSAPrivateKey
extends PrivateKey {
    private BigInteger modulus;
    private BigInteger privateExponent;

    public RSAPrivateKey(SignatureAlgorithm signatureAlgorithm, BigInteger modulus, BigInteger privateExponent) {
        this.setSignatureAlgorithm(signatureAlgorithm);
        this.modulus = modulus;
        this.privateExponent = privateExponent;
    }

    public RSAPrivateKey(SignatureAlgorithm signatureAlgorithm, String modulus, String privateExponent) {
        this.setSignatureAlgorithm(signatureAlgorithm);
        this.modulus = new BigInteger(1, Base64Util.base64urldecode(modulus));
        this.privateExponent = new BigInteger(1, Base64Util.base64urldecode(privateExponent));
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public void setModulus(BigInteger modulus) {
        this.modulus = modulus;
    }

    public BigInteger getPrivateExponent() {
        return this.privateExponent;
    }

    public void setPrivateExponent(BigInteger privateExponent) {
        this.privateExponent = privateExponent;
    }

    @Override
    public JSONObject toJSONObject() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("n", (Object)Base64Util.base64urlencodeUnsignedBigInt(this.modulus));
        jsonObject.put("e", (Object)Base64Util.base64urlencodeUnsignedBigInt(this.privateExponent));
        jsonObject.put("d", JSONObject.NULL);
        return jsonObject;
    }

    public String toString() {
        try {
            return this.toJSONObject().toString(4);
        }
        catch (Exception e) {
            return "";
        }
    }
}

