/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.jwt;

import io.jans.as.model.crypto.encryption.BlockEncryptionAlgorithm;
import io.jans.as.model.crypto.encryption.KeyEncryptionAlgorithm;
import io.jans.as.model.crypto.signature.SignatureAlgorithm;
import io.jans.as.model.exception.InvalidJwtException;
import io.jans.as.model.jwt.JwtClaimSet;
import io.jans.as.model.jwt.JwtType;
import org.json.JSONObject;

public class JwtHeader
extends JwtClaimSet {
    public JwtHeader() {
    }

    public JwtHeader(JSONObject jsonObject) {
        super(jsonObject);
    }

    public JwtHeader(String base64JsonObject) throws InvalidJwtException {
        super(base64JsonObject);
    }

    public static JwtHeader instance() {
        return new JwtHeader();
    }

    public JwtHeader setType(JwtType type) {
        if (type == null) {
            this.setNullClaim("typ");
        } else {
            this.setClaim("typ", type.toString());
        }
        return this;
    }

    public JwtType getType() {
        String typ = this.getClaimAsString("typ");
        return JwtType.fromString(typ);
    }

    public SignatureAlgorithm getSignatureAlgorithm() {
        String alg = this.getClaimAsString("alg");
        return SignatureAlgorithm.fromString(alg);
    }

    public JwtHeader setAlgorithm(SignatureAlgorithm algorithm) {
        if (algorithm == null) {
            this.setNullClaim("alg");
        } else {
            this.setClaim("alg", algorithm.toString());
        }
        return this;
    }

    public JwtHeader setAlgorithm(KeyEncryptionAlgorithm algorithm) {
        if (algorithm == null) {
            this.setNullClaim("alg");
        } else {
            this.setClaim("alg", algorithm.toString());
        }
        return this;
    }

    public String getKeyId() {
        return this.getClaimAsString("kid");
    }

    public JwtHeader setKeyId(String keyId) {
        this.setClaim("kid", keyId);
        return this;
    }

    public JSONObject getJwk() {
        return this.getClaimAsJSON("jwk");
    }

    public JwtHeader setJwk(JSONObject jwk) {
        this.setClaim("jwk", jwk);
        return this;
    }

    public void setContentType(JwtType contentType) {
        if (contentType == null) {
            this.setNullClaim("cty");
        } else {
            this.setClaim("cty", contentType.toString());
        }
    }

    public JwtType getContentType() {
        return JwtType.fromString(this.getClaimAsString("cty"));
    }

    public void setEncryptionMethod(BlockEncryptionAlgorithm encryptionMethod) {
        if (encryptionMethod == null) {
            this.setNullClaim("enc");
        } else {
            this.setClaim("enc", encryptionMethod.toString());
        }
    }

    public BlockEncryptionAlgorithm getEncryptionMethod() {
        return BlockEncryptionAlgorithm.fromName(this.getClaimAsString("enc"));
    }

    public void setEphemeralPublicKey(String ephemeralPublicKey) {
        this.setClaim("epk", ephemeralPublicKey);
    }

    public void setCompressionAlgorithm(String compressionAlgorithm) {
        this.setClaim("zip", compressionAlgorithm);
    }

    public void setAgreementPartyUInfo(String agreementPartyUInfo) {
        this.setClaim("apu", agreementPartyUInfo);
    }

    public void setAgreementPartyVInfo(String agreementPartyVInfo) {
        this.setClaim("apv", agreementPartyVInfo);
    }

    public void setEncryptionPartyUInfo(String encryptionPartyUInfo) {
        this.setClaim("epu", encryptionPartyUInfo);
    }

    public void setEncryptionPartyVInfo(String encryptionPartyVInfo) {
        this.setClaim("epv", encryptionPartyVInfo);
    }
}

