/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.jwt;

import io.jans.as.model.util.Base64Util;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;

public class PureJwt {
    private final String encodedHeader;
    private final String encodedPayload;
    private final String encodedSignature;
    private final String signingInput;
    private final String decodedHeader;
    private final String decodedPayload;

    public PureJwt(String encodedHeader, String encodedPayload, String encodedSignature) {
        this.encodedHeader = encodedHeader;
        this.encodedPayload = encodedPayload;
        this.encodedSignature = encodedSignature;
        this.signingInput = this.encodedHeader + "." + this.encodedPayload;
        String decodedPayloadTemp = null;
        String decodedHeaderTemp = null;
        decodedHeaderTemp = new String(Base64Util.base64urldecode(encodedHeader), StandardCharsets.UTF_8);
        decodedPayloadTemp = new String(Base64Util.base64urldecode(encodedPayload), StandardCharsets.UTF_8);
        this.decodedHeader = decodedHeaderTemp;
        this.decodedPayload = decodedPayloadTemp;
    }

    public static PureJwt parse(String encodedString) {
        if (StringUtils.isNotBlank((CharSequence)encodedString)) {
            String[] jwtParts = encodedString.split("\\.");
            if (jwtParts.length == 3) {
                return new PureJwt(jwtParts[0], jwtParts[1], jwtParts[2]);
            }
            if (jwtParts.length == 2) {
                return new PureJwt(jwtParts[0], jwtParts[1], "");
            }
        }
        return null;
    }

    public String getDecodedHeader() {
        return this.decodedHeader;
    }

    public String getDecodedPayload() {
        return this.decodedPayload;
    }

    public String getSigningInput() {
        return this.signingInput;
    }

    public String getEncodedHeader() {
        return this.encodedHeader;
    }

    public String getEncodedPayload() {
        return this.encodedPayload;
    }

    public String getEncodedSignature() {
        return this.encodedSignature;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PureJwt pureJwt = (PureJwt)o;
        if (this.encodedHeader != null ? !this.encodedHeader.equals(pureJwt.encodedHeader) : pureJwt.encodedHeader != null) {
            return false;
        }
        if (this.encodedPayload != null ? !this.encodedPayload.equals(pureJwt.encodedPayload) : pureJwt.encodedPayload != null) {
            return false;
        }
        return this.encodedSignature != null ? this.encodedSignature.equals(pureJwt.encodedSignature) : pureJwt.encodedSignature == null;
    }

    public int hashCode() {
        int result = this.encodedHeader != null ? this.encodedHeader.hashCode() : 0;
        result = 31 * result + (this.encodedPayload != null ? this.encodedPayload.hashCode() : 0);
        result = 31 * result + (this.encodedSignature != null ? this.encodedSignature.hashCode() : 0);
        return result;
    }
}

