/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.config.adminui;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.jans.as.model.config.adminui.KeyValuePair;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class OIDCClientSettings {
    private String introspectionEndpoint;
    private String tokenEndpoint;
    private String redirectUri;
    private String postLogoutUri;
    private String frontchannelLogoutUri;
    private List<String> scopes;
    private List<String> acrValues;
    private String opHost;
    private String clientId;
    private String clientSecret;
    private List<KeyValuePair> additionalParameters;

    public OIDCClientSettings() {
    }

    public OIDCClientSettings(String opHost, String clientId, String clientSecret) {
        this.opHost = opHost;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    public OIDCClientSettings(OIDCClientSettings oidcClientSettings) {
        this.introspectionEndpoint = oidcClientSettings.getIntrospectionEndpoint();
        this.tokenEndpoint = oidcClientSettings.getTokenEndpoint();
        this.redirectUri = oidcClientSettings.getRedirectUri();
        this.postLogoutUri = oidcClientSettings.getPostLogoutUri();
        this.frontchannelLogoutUri = oidcClientSettings.getFrontchannelLogoutUri();
        this.scopes = oidcClientSettings.getScopes();
        this.acrValues = oidcClientSettings.getAcrValues();
        this.opHost = oidcClientSettings.getOpHost();
        this.clientId = oidcClientSettings.getClientId();
        this.clientSecret = oidcClientSettings.getClientSecret();
        this.additionalParameters = oidcClientSettings.getAdditionalParameters();
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public String getOpHost() {
        return this.opHost;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public String getClientId() {
        return this.clientId;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public String getPostLogoutUri() {
        return this.postLogoutUri;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public List<String> getAcrValues() {
        return this.acrValues;
    }

    public void setAcrValues(List<String> acrValues) {
        this.acrValues = acrValues;
    }

    public String getFrontchannelLogoutUri() {
        return this.frontchannelLogoutUri;
    }

    public String getIntrospectionEndpoint() {
        return this.introspectionEndpoint;
    }

    public List<KeyValuePair> getAdditionalParameters() {
        return this.additionalParameters;
    }

    public void setAdditionalParameters(List<KeyValuePair> additionalParameters) {
        this.additionalParameters = additionalParameters;
    }

    public String toString() {
        return "OIDCClientSettings{introspectionEndpoint='" + this.introspectionEndpoint + "', tokenEndpoint='" + this.tokenEndpoint + "', redirectUri='" + this.redirectUri + "', postLogoutUri='" + this.postLogoutUri + "', frontchannelLogoutUri='" + this.frontchannelLogoutUri + "', scopes=" + this.scopes + ", acrValues=" + this.acrValues + ", opHost='" + this.opHost + "', clientId='" + this.clientId + "', clientSecret='" + this.clientSecret + "', additionalParameters='" + this.additionalParameters + "'}";
    }
}

