/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.crypto.binding;

import io.jans.as.model.crypto.binding.TokenBindingKeyParameters;
import io.jans.as.model.util.Base64Util;
import org.apache.commons.codec.digest.DigestUtils;

public class TokenBindingID {
    private final TokenBindingKeyParameters keyParameters;
    private final byte[] publicKey;
    private final byte[] raw;

    public TokenBindingID(TokenBindingKeyParameters keyParameters, byte[] publicKey, byte[] raw) {
        this.keyParameters = keyParameters;
        this.publicKey = publicKey;
        this.raw = raw;
    }

    public TokenBindingKeyParameters getKeyParameters() {
        return this.keyParameters;
    }

    public byte[] getPublicKey() {
        return this.publicKey;
    }

    public byte[] getRaw() {
        return this.raw;
    }

    public byte[] sha256() {
        return DigestUtils.sha256((byte[])this.raw);
    }

    public String sha256base64url() {
        return Base64Util.base64urlencode(this.sha256());
    }
}

