/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.crypto.signature;

import io.jans.as.model.crypto.PublicKey;
import io.jans.as.model.crypto.signature.SignatureAlgorithm;
import io.jans.as.model.util.Base64Util;
import java.math.BigInteger;
import org.json.JSONException;
import org.json.JSONObject;

public class ECDSAPublicKey
extends PublicKey {
    private SignatureAlgorithm signatureAlgorithm;
    private BigInteger x;
    private BigInteger y;

    public ECDSAPublicKey(SignatureAlgorithm signatureAlgorithm, BigInteger x, BigInteger y) {
        this.signatureAlgorithm = signatureAlgorithm;
        this.x = x;
        this.y = y;
    }

    public ECDSAPublicKey(SignatureAlgorithm signatureAlgorithm, String x, String y) {
        this(signatureAlgorithm, new BigInteger(1, Base64Util.base64urldecode(x)), new BigInteger(1, Base64Util.base64urldecode(y)));
    }

    @Override
    public SignatureAlgorithm getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    @Override
    public void setSignatureAlgorithm(SignatureAlgorithm signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
    }

    public BigInteger getX() {
        return this.x;
    }

    public void setX(BigInteger x) {
        this.x = x;
    }

    public BigInteger getY() {
        return this.y;
    }

    public void setY(BigInteger y) {
        this.y = y;
    }

    @Override
    public JSONObject toJSONObject() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("n", JSONObject.NULL);
        jsonObject.put("e", JSONObject.NULL);
        jsonObject.put("x", (Object)Base64Util.base64urlencodeUnsignedBigInt(this.x));
        jsonObject.put("y", (Object)Base64Util.base64urlencodeUnsignedBigInt(this.y));
        return jsonObject;
    }

    public String toString() {
        try {
            return this.toJSONObject().toString(4);
        }
        catch (Exception e) {
            return "";
        }
    }
}

