/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.crypto.signature;

import io.jans.as.model.crypto.PublicKey;
import io.jans.as.model.crypto.signature.SignatureAlgorithm;
import io.jans.as.model.util.Base64Util;
import java.security.spec.X509EncodedKeySpec;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.json.JSONException;
import org.json.JSONObject;

public class EDDSAPublicKey
extends PublicKey {
    private final byte[] xEncoded;

    public EDDSAPublicKey(SignatureAlgorithm signatureAlgorithm, byte[] xEncoded) {
        this.setSignatureAlgorithm(signatureAlgorithm);
        this.xEncoded = (byte[])xEncoded.clone();
    }

    public EDDSAPublicKey(EDDSAPublicKey eddsaPublicKey) {
        this.setSignatureAlgorithm(eddsaPublicKey.getSignatureAlgorithm());
        byte[] inXEncoded = eddsaPublicKey.getPublicKeyEncoded();
        this.xEncoded = inXEncoded != null ? (byte[])inXEncoded.clone() : null;
        this.setKeyId(eddsaPublicKey.getKeyId());
        this.setCertificate(eddsaPublicKey.getCertificate());
    }

    public X509EncodedKeySpec getPublicKeySpec() {
        return new X509EncodedKeySpec(this.xEncoded);
    }

    public byte[] getPublicKeyDecoded() {
        if (this.xEncoded == null) {
            return new byte[0];
        }
        SubjectPublicKeyInfo subjPubKeyInfo = SubjectPublicKeyInfo.getInstance((Object)this.xEncoded);
        return subjPubKeyInfo.getPublicKeyData().getOctets();
    }

    public byte[] getPublicKeyEncoded() {
        return this.xEncoded != null ? this.xEncoded : new byte[]{};
    }

    @Override
    public JSONObject toJSONObject() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("n", JSONObject.NULL);
        jsonObject.put("e", JSONObject.NULL);
        jsonObject.put("x", (Object)Base64Util.base64urlencode(this.xEncoded));
        return jsonObject;
    }

    public String toString() {
        try {
            return this.toJSONObject().toString(4);
        }
        catch (Exception e) {
            return "";
        }
    }
}

