/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.error;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.jans.as.model.authorize.AuthorizeErrorResponseType;
import io.jans.as.model.ciba.BackchannelAuthenticationErrorResponseType;
import io.jans.as.model.clientinfo.ClientInfoErrorResponseType;
import io.jans.as.model.common.FeatureFlagType;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.configuration.Configuration;
import io.jans.as.model.error.DefaultErrorResponse;
import io.jans.as.model.error.ErrorMessages;
import io.jans.as.model.error.ErrorResponse;
import io.jans.as.model.error.IErrorType;
import io.jans.as.model.error.JsonErrorResponse;
import io.jans.as.model.fido.u2f.U2fErrorResponseType;
import io.jans.as.model.register.RegisterErrorResponseType;
import io.jans.as.model.session.EndSessionErrorResponseType;
import io.jans.as.model.ssa.SsaErrorResponseType;
import io.jans.as.model.token.TokenErrorResponseType;
import io.jans.as.model.token.TokenRevocationErrorResponseType;
import io.jans.as.model.uma.UmaErrorResponseType;
import io.jans.as.model.userinfo.UserInfoErrorResponseType;
import io.jans.as.model.util.Util;
import io.jans.model.error.ErrorMessage;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.logging.log4j.ThreadContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorResponseFactory
implements Configuration {
    private static final Logger log = LoggerFactory.getLogger(ErrorResponseFactory.class);
    private ErrorMessages messages;
    private AppConfiguration appConfiguration;

    public ErrorResponseFactory() {
    }

    public ErrorResponseFactory(ErrorMessages messages, AppConfiguration appConfiguration) {
        this.messages = messages;
        this.appConfiguration = appConfiguration;
    }

    public ErrorMessages getMessages() {
        return this.messages;
    }

    public void setMessages(ErrorMessages messages) {
        this.messages = messages;
    }

    private ErrorMessage getError(List<ErrorMessage> list, IErrorType type) {
        log.debug("Looking for the error with id: {}", (Object)type);
        if (list != null) {
            for (ErrorMessage error : list) {
                if (!error.getId().equals(type.getParameter())) continue;
                log.debug("Found error, id: {}", (Object)type);
                return error;
            }
        }
        log.error("Error not found, id: {}", (Object)type);
        return new ErrorMessage(type.getParameter(), type.getParameter(), null);
    }

    public String getErrorAsJson(IErrorType type) {
        return this.getErrorResponse(type).toJSonString();
    }

    public String errorAsJson(IErrorType type, String reason) {
        DefaultErrorResponse error = this.getErrorResponse(type);
        error.setReason(BooleanUtils.isTrue((Boolean)this.appConfiguration.getErrorReasonEnabled()) ? reason : "");
        return error.toJSonString();
    }

    public boolean isFeatureFlagEnabled(FeatureFlagType flagType) {
        Set<FeatureFlagType> enabledFlags = FeatureFlagType.from(this.appConfiguration);
        if (enabledFlags.isEmpty()) {
            return true;
        }
        return enabledFlags.contains((Object)flagType);
    }

    public void validateFeatureEnabled(FeatureFlagType flagType) {
        Set<FeatureFlagType> enabledFlags = FeatureFlagType.from(this.appConfiguration);
        if (enabledFlags.isEmpty()) {
            return;
        }
        if (enabledFlags.contains((Object)flagType)) {
            return;
        }
        log.info("Feature flag is disabled, type: {}", (Object)flagType);
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.errorAsJson(TokenErrorResponseType.ACCESS_DENIED, "Feature flag is disabled on server.")).type(MediaType.APPLICATION_JSON_TYPE).build());
    }

    public Response.ResponseBuilder newErrorResponse(Response.Status status) {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoStore(true);
        return Response.status((Response.Status)status).cacheControl(cacheControl).type(MediaType.APPLICATION_JSON_TYPE);
    }

    public WebApplicationException createWebApplicationException(Response.Status status, IErrorType type, String reason) throws WebApplicationException {
        return new WebApplicationException(Response.status((Response.Status)status).entity((Object)this.errorAsJson(type, reason)).type(MediaType.APPLICATION_JSON_TYPE).build());
    }

    @NotNull
    public WebApplicationException createBadRequestException(@NotNull ErrorResponse error) {
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)error.toJSonString()).build());
    }

    @NotNull
    public WebApplicationException createBadRequestException(@NotNull IErrorType error, @Nullable String state) {
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.getErrorAsJson(error, state, "")).build());
    }

    public String getErrorAsJson(IErrorType type, String state, String reason) {
        return this.getErrorResponse(type, state, reason).toJSonString();
    }

    public String getErrorAsQueryString(IErrorType type, String state) {
        return this.getErrorAsQueryString(type, state, "");
    }

    public String getErrorAsQueryString(IErrorType type, String state, String reason) {
        return this.getErrorResponse(type, state, reason).toQueryString();
    }

    public DefaultErrorResponse getErrorResponse(IErrorType type, String state, String reason) {
        DefaultErrorResponse response = this.getErrorResponse(type);
        response.setState(state);
        response.setReason(reason);
        return response;
    }

    public DefaultErrorResponse getErrorResponse(IErrorType type) {
        DefaultErrorResponse response = new DefaultErrorResponse();
        response.setType(type);
        if (type != null && this.messages != null) {
            List<ErrorMessage> list = null;
            if (type instanceof AuthorizeErrorResponseType) {
                list = this.messages.getAuthorize();
            } else if (type instanceof ClientInfoErrorResponseType) {
                list = this.messages.getClientInfo();
            } else if (type instanceof EndSessionErrorResponseType) {
                list = this.messages.getEndSession();
            } else if (type instanceof RegisterErrorResponseType) {
                list = this.messages.getRegister();
            } else if (type instanceof TokenErrorResponseType) {
                list = this.messages.getToken();
            } else if (type instanceof TokenRevocationErrorResponseType) {
                list = this.messages.getRevoke();
            } else if (type instanceof UmaErrorResponseType) {
                list = this.messages.getUma();
            } else if (type instanceof UserInfoErrorResponseType) {
                list = this.messages.getUserInfo();
            } else if (type instanceof U2fErrorResponseType) {
                list = this.messages.getFido();
            } else if (type instanceof BackchannelAuthenticationErrorResponseType) {
                list = this.messages.getBackchannelAuthentication();
            } else if (type instanceof SsaErrorResponseType) {
                list = this.messages.getSsa();
            }
            if (list != null) {
                ErrorMessage m = this.getError(list, type);
                String description = Optional.ofNullable(ThreadContext.get((String)"X-Correlation-Id")).map(id -> m.getDescription().concat(" CorrelationId: " + id)).orElse(m.getDescription());
                response.setErrorDescription(description);
                response.setErrorUri(m.getUri());
            }
        }
        return response;
    }

    public String getJsonErrorResponse(IErrorType type) {
        DefaultErrorResponse response = this.getErrorResponse(type);
        JsonErrorResponse jsonErrorResponse = new JsonErrorResponse(response);
        try {
            ObjectMapper mapper = Util.createJsonMapper().configure(SerializationFeature.WRAP_ROOT_VALUE, false);
            return mapper.writeValueAsString((Object)jsonErrorResponse);
        }
        catch (IOException ex) {
            log.error("Failed to generate error response", (Throwable)ex);
            return null;
        }
    }
}

