/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.json;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public enum PropertyDefinition {
    ADDITIONAL_AUDIENCE(Sets.newHashSet((Object[])new ClassNames[]{ClassNames.CLIENT_ATTRIBUTES, ClassNames.REGISTER_REQUEST}), "additionalAudience", List.class, "additional_audience");

    private final Set<ClassNames> javaTargetsClassNames;
    private final Set<String> javaTargetsClassNamesAsStrings;
    private final String javaTargetPropertyName;
    private final Class<?> javaType;
    private final String jsonName;

    private PropertyDefinition(Set<ClassNames> javaTargetsClassNames, String javaTargetPropertyName, Class<?> javaType, String jsonName) {
        this.javaTargetsClassNames = javaTargetsClassNames;
        this.javaTargetsClassNamesAsStrings = javaTargetsClassNames.stream().map(ClassNames::getFullClassName).collect(Collectors.toSet());
        this.javaTargetPropertyName = javaTargetPropertyName;
        this.javaType = javaType;
        this.jsonName = jsonName;
    }

    public Class<?> getJavaType() {
        return this.javaType;
    }

    public Set<ClassNames> getJavaTargetsClassNames() {
        return this.javaTargetsClassNames;
    }

    public Set<String> getJavaTargetsClassNamesAsStrings() {
        return this.javaTargetsClassNamesAsStrings;
    }

    public String getJavaTargetPropertyName() {
        return this.javaTargetPropertyName;
    }

    public String getJsonName() {
        return this.jsonName;
    }

    public String toString() {
        return "PropertyDefinition{javaTargetsClassNames='" + this.javaTargetsClassNames + "', javaTargetPropertyName='" + this.javaTargetPropertyName + "', javaType='" + this.javaType + "', jsonName='" + this.jsonName + "'} " + super.toString();
    }

    public static enum ClassNames {
        CLIENT_ATTRIBUTES("io.jans.as.persistence.model.ClientAttributes"),
        REGISTER_REQUEST("io.jans.as.client.RegisterRequest");

        private final String fullClassName;

        private ClassNames(String fullClassName) {
            this.fullClassName = fullClassName;
        }

        public String getFullClassName() {
            return this.fullClassName;
        }
    }
}

