/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.jwk;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;

public enum KeyOpsType {
    CONNECT("connect"),
    SSA("ssa"),
    ALL("all");

    private final String value;

    private KeyOpsType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    @JsonCreator
    public static KeyOpsType fromString(String valueString) {
        if (valueString != null) {
            for (KeyOpsType v : KeyOpsType.values()) {
                if (!valueString.equalsIgnoreCase(v.name())) continue;
                return v;
            }
        }
        return null;
    }

    public static List<KeyOpsType> fromJSONArray(JSONArray jsonArray) {
        ArrayList<KeyOpsType> result = new ArrayList<KeyOpsType>();
        if (jsonArray == null) {
            return result;
        }
        for (int i = 0; i < jsonArray.length(); ++i) {
            KeyOpsType v = KeyOpsType.fromString(jsonArray.optString(i));
            if (v == null) continue;
            result.add(v);
        }
        return result;
    }

    public String toString() {
        return "KeyOps{value='" + this.value + "'} " + super.toString();
    }
}

