/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.jws;

import io.jans.as.model.crypto.signature.SignatureAlgorithm;
import io.jans.as.model.exception.InvalidJwtException;
import io.jans.as.model.jws.JwsSigner;
import io.jans.as.model.jwt.Jwt;
import io.jans.as.model.util.HashUtil;
import java.security.SignatureException;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public abstract class AbstractJwsSigner
implements JwsSigner {
    private static final Logger LOG = Logger.getLogger(AbstractJwsSigner.class);
    private final SignatureAlgorithm signatureAlgorithm;

    protected AbstractJwsSigner(SignatureAlgorithm signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
    }

    @Override
    public SignatureAlgorithm getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    @Override
    public Jwt sign(Jwt jwt) throws InvalidJwtException, SignatureException {
        String signature = this.generateSignature(jwt.getSigningInput());
        jwt.setEncodedSignature(signature);
        return jwt;
    }

    @Override
    public boolean validate(Jwt jwt) {
        try {
            String signingInput = jwt.getSigningInput();
            String signature = jwt.getEncodedSignature();
            return this.validateSignature(signingInput, signature);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean validateAuthorizationCode(String authorizationCode, Jwt idToken) {
        return this.validateHash(authorizationCode, idToken.getClaims().getClaimAsString("c_hash"));
    }

    public boolean validateAccessToken(String accessToken, Jwt idToken) {
        return this.validateHash(accessToken, idToken.getClaims().getClaimAsString("at_hash"));
    }

    public boolean validateState(String state, Jwt idToken) {
        return this.validateHash(state, idToken.getClaims().getClaimAsString("s_hash"));
    }

    private boolean validateHash(String tokenCode, String tokenHash) {
        if (StringUtils.isBlank((CharSequence)tokenCode) || StringUtils.isBlank((CharSequence)tokenHash)) {
            return false;
        }
        return tokenHash.equals(HashUtil.getHash(tokenCode, this.signatureAlgorithm));
    }

    public abstract String generateSignature(String var1) throws SignatureException;

    public abstract boolean validateSignature(String var1, String var2) throws SignatureException;
}

