/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.common;

import io.jans.as.model.authzdetails.AuthzDetail;
import io.jans.as.model.authzdetails.AuthzDetails;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONArray;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class AuthzDetailsTest {
    @Test
    public void isEmpty_forNull_shouldReturnTrue() {
        Assert.assertTrue((boolean)AuthzDetails.isEmpty(null));
    }

    @Test
    public void isEmpty_forEmptyDetails_shouldReturnTrue() {
        Assert.assertTrue((boolean)AuthzDetails.isEmpty((AuthzDetails)new AuthzDetails()));
    }

    @Test
    public void isEmpty_forNonEmptyDetails_shouldReturnFalse() {
        AuthzDetails authzDetails = new AuthzDetails();
        authzDetails.getDetails().add(new AuthzDetail("{}"));
        Assert.assertFalse((boolean)AuthzDetails.isEmpty((AuthzDetails)authzDetails));
    }

    @Test
    public void ofSilently_withInvalidJson_shouldReturnNull() {
        Assert.assertNull((Object)AuthzDetails.ofSilently((String)"invalidJson"));
    }

    @Test
    public void ofSilently_withValidJson_shouldReturnNotNull() {
        AssertJUnit.assertNotNull((Object)AuthzDetails.ofSilently((String)"[]"));
    }

    @Test
    public void getTypes_withValidJson_shouldReturnNotNull() {
        AuthzDetails details = AuthzDetails.ofSilently((String)"[{\"type\":\"internal_type\"}]");
        AssertJUnit.assertNotNull((Object)details);
        Assert.assertEquals((Set)details.getTypes(), new HashSet<String>(Collections.singletonList("internal_type")));
    }

    @Test
    public void getJsonArray_withValidJson_shouldReturnNotNull() {
        AuthzDetails details = AuthzDetails.ofSilently((String)"[{\"type\":\"internal_type\"}]");
        AssertJUnit.assertNotNull((Object)details);
        JSONArray array = details.asJsonArray();
        Assert.assertEquals((String)array.toString(), (String)"[{\"type\":\"internal_type\"}]");
        Assert.assertTrue((boolean)array.similar((Object)new JSONArray("[{\"type\":\"internal_type\"}]")));
    }

    @Test
    public void similar_forSameJson_shouldReturnTrue() {
        String a1 = "[\n  {\n    \"type\": \"internal_a1\"\n  },\n  {\n    \"type\": \"internal_a2\"\n  }\n]";
        String a2 = "[\n  {\n    \"type\": \"internal_a1\"\n  },\n  {\n    \"type\": \"internal_a2\"\n  }\n]";
        Assert.assertTrue((boolean)AuthzDetails.similar((String)a1, (String)a2));
    }

    @Test
    public void asJsonArray_whenCalled_shouldReturnExpectedArray() {
        String a1 = "[\n  {\n    \"type\": \"internal_a1\"\n  },\n  {\n    \"type\": \"internal_a2\"\n  }\n]";
        AuthzDetails authzDetails = AuthzDetails.of((String)a1);
        Assert.assertTrue((boolean)authzDetails.asJsonArray().similar((Object)new JSONArray(a1)));
    }
}

