/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.jwk;

import com.nimbusds.jose.jwk.JWKException;
import io.jans.as.model.crypto.signature.EllipticEdvardsCurve;
import io.jans.as.model.jwk.Algorithm;
import io.jans.as.model.jwk.JSONWebKey;
import io.jans.as.model.jwk.KeyType;
import io.jans.util.security.SecurityProviderUtility;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.Test;

public class JSONWebKeyTest {
    @Test
    public void rsaPublicKey() throws UnsupportedEncodingException, JWKException, NoSuchAlgorithmException, NoSuchProviderException {
        String publicKeyStr = "{\n      \"kty\": \"RSA\",\n      \"n\": \"0vx7agoebGcQSuuPiLJXZptN9nndrQmbXEps2aiAFbWhM78LhWx4cbbfAAtVT86zwu1RK7aPFFxuhDR1L6tSoc_BJECPebWKRXjBZCiFV4n3oknjhMstn64tZ_2W-5JsGY4Hc5n9yBXArwl93lqt7_RN5w6Cf0h4QyQ5v-65YGjQR0_FDW2QvzqY368QQMicAtaSqzs8KJZgnYb9c7d0zgdAZHzu6qMQvRL5hajrn1n91CbOpbISD08qNLyrdkt-bFTWhAI4vMQFh6WeZu0fM4lFd2NcRwr3XPksINHaQ-G_xBniIqbw0Ls1jF44-csFCur-kEgU8awapJzKnqDKgw\",\n      \"e\": \"AQAB\",\n      \"alg\": \"RS256\",\n      \"kid\": \"2011-04-29\"\n}";
        JSONObject jwkJSONObject = new JSONObject("{\n      \"kty\": \"RSA\",\n      \"n\": \"0vx7agoebGcQSuuPiLJXZptN9nndrQmbXEps2aiAFbWhM78LhWx4cbbfAAtVT86zwu1RK7aPFFxuhDR1L6tSoc_BJECPebWKRXjBZCiFV4n3oknjhMstn64tZ_2W-5JsGY4Hc5n9yBXArwl93lqt7_RN5w6Cf0h4QyQ5v-65YGjQR0_FDW2QvzqY368QQMicAtaSqzs8KJZgnYb9c7d0zgdAZHzu6qMQvRL5hajrn1n91CbOpbISD08qNLyrdkt-bFTWhAI4vMQFh6WeZu0fM4lFd2NcRwr3XPksINHaQ-G_xBniIqbw0Ls1jF44-csFCur-kEgU8awapJzKnqDKgw\",\n      \"e\": \"AQAB\",\n      \"alg\": \"RS256\",\n      \"kid\": \"2011-04-29\"\n}");
        JSONWebKey jsonWebKey = JSONWebKey.fromJSONObject((JSONObject)jwkJSONObject);
        Assert.assertEquals((Object)jsonWebKey.getKty(), (Object)KeyType.RSA);
        Assert.assertEquals((Object)jsonWebKey.getAlg(), (Object)Algorithm.RS256);
        Assert.assertNotNull((Object)jsonWebKey.getN());
        Assert.assertNotNull((Object)jsonWebKey.getE());
        Assert.assertNotNull((Object)jsonWebKey.getKid());
        String jwkThumbprint = jsonWebKey.getJwkThumbprint();
        Assert.assertEquals((String)jwkThumbprint, (String)"NzbLsXh8uDCcd-6MNwXF4W_7noWXFZAfHkxZsRGC9Xs");
    }

    @Test
    public void ecPublicKey() throws UnsupportedEncodingException, JWKException, NoSuchAlgorithmException, NoSuchProviderException {
        String publicKeyStr = "{\n      \"kty\": \"EC\",\n      \"crv\": \"P-256\",\n      \"x\": \"MKBCTNIcKUSDii11ySs3526iDZ8AiTo7Tu6KPAqv7D4\",\n      \"y\": \"4Etl6SRW2YiLUrN5vfvVHuhp7x8PxltmWWlbbM4IFyM\",\n      \"use\": \"enc\",\n      \"kid\": \"1\"\n}";
        JSONObject jwkJSONObject = new JSONObject("{\n      \"kty\": \"EC\",\n      \"crv\": \"P-256\",\n      \"x\": \"MKBCTNIcKUSDii11ySs3526iDZ8AiTo7Tu6KPAqv7D4\",\n      \"y\": \"4Etl6SRW2YiLUrN5vfvVHuhp7x8PxltmWWlbbM4IFyM\",\n      \"use\": \"enc\",\n      \"kid\": \"1\"\n}");
        JSONWebKey jsonWebKey = JSONWebKey.fromJSONObject((JSONObject)jwkJSONObject);
        Assert.assertEquals((Object)jsonWebKey.getKty(), (Object)KeyType.EC);
        Assert.assertEquals((Object)jsonWebKey.getCrv(), (Object)EllipticEdvardsCurve.P_256);
        Assert.assertNotNull((Object)jsonWebKey.getX());
        Assert.assertNotNull((Object)jsonWebKey.getY());
        Assert.assertNotNull((Object)jsonWebKey.getKid());
        String jwkThumbprint = jsonWebKey.getJwkThumbprint();
        Assert.assertEquals((String)jwkThumbprint, (String)"cn-I_WNMClehiVp51i_0VpOENW1upEerA8sEam5hn-s");
    }

    static {
        SecurityProviderUtility.installBCProvider((boolean)true);
    }
}

