/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.uma;

import io.jans.as.model.uma.JsonLogic;
import javax.script.ScriptException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class JsonLogicTest {
    private static void assertResult(String script, Boolean expectedResult) throws ScriptException {
        Assert.assertEquals((Object)JsonLogic.eval((String)script), (Object)expectedResult);
    }

    private static void assertTrue(String script) throws ScriptException {
        JsonLogicTest.assertResult(script, Boolean.TRUE);
    }

    private static void assertFalse(String script) throws ScriptException {
        JsonLogicTest.assertResult(script, Boolean.FALSE);
    }

    @Test
    public void testJsEngine() throws ScriptException, NoSuchMethodException {
        JsonLogic.eval((String)"var fun1 = function(name) {\n    print('Hi there from Javascript, ' + name);\n    return \"greetings from javascript\";\n};");
        Object result = JsonLogic.invokeFunction((String)"fun1", (Object[])new Object[]{""});
        Assert.assertEquals((Object)result, (Object)"greetings from javascript");
    }

    @Test
    public void testJsonLogic() throws ScriptException, NoSuchMethodException {
        JsonLogicTest.assertTrue("jsonLogic.apply( { \"==\" : [1, 1] } );");
        JsonLogicTest.assertFalse("jsonLogic.apply( { \"==\" : [1, 0] } );");
        Assert.assertTrue((boolean)JsonLogic.apply((String)"{ \"==\" : [1, 1] }"));
        Assert.assertFalse((boolean)JsonLogic.apply((String)"{ \"==\" : [1, 0] }"));
        JsonLogicTest.assertTrue("jsonLogic.apply(\n  {\"and\" : [\n    { \">\" : [3,1] },\n    { \"<\" : [1,3] }\n  ] }\n);");
    }

    @Test
    public void umaSimulation() throws ScriptException {
        String rule = "{    \"and\": [ {        \"or\": [          {\"var\": 0 },          {\"var\": 1 }        ]      },      {\"var\": 2 }    ]}";
        Assert.assertTrue((boolean)JsonLogic.apply((String)rule, (String)"[true, true, true]"));
        Assert.assertTrue((boolean)JsonLogic.apply((String)rule, (String)"[true, false, true]"));
        Assert.assertTrue((boolean)JsonLogic.apply((String)rule, (String)"[false, true, true]"));
        Assert.assertFalse((boolean)JsonLogic.apply((String)rule, (String)"[false, false, false]"));
        Assert.assertFalse((boolean)JsonLogic.apply((String)rule, (String)"[false, false, true]"));
        Assert.assertFalse((boolean)JsonLogic.apply((String)rule, (String)"[true, true, false]"));
    }
}

