/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;

public enum AuthenticationMethod {
    CLIENT_SECRET_BASIC("client_secret_basic"),
    CLIENT_SECRET_POST("client_secret_post"),
    CLIENT_SECRET_JWT("client_secret_jwt"),
    PRIVATE_KEY_JWT("private_key_jwt"),
    ACCESS_TOKEN("access_token"),
    TLS_CLIENT_AUTH("tls_client_auth"),
    SELF_SIGNED_TLS_CLIENT_AUTH("self_signed_tls_client_auth"),
    NONE("none");

    private final String paramName;

    private AuthenticationMethod(String paramName) {
        this.paramName = paramName;
    }

    @JsonCreator
    public static AuthenticationMethod fromString(String param) {
        if (param != null) {
            for (AuthenticationMethod rt : AuthenticationMethod.values()) {
                if (!param.equals(rt.paramName)) continue;
                return rt;
            }
        }
        return null;
    }

    public static List<AuthenticationMethod> fromList(List<String> list) {
        ArrayList<AuthenticationMethod> result = new ArrayList<AuthenticationMethod>();
        for (String s : list) {
            AuthenticationMethod authenticationMethod = AuthenticationMethod.fromString(s);
            if (authenticationMethod == null) continue;
            result.add(authenticationMethod);
        }
        return result;
    }

    @JsonValue
    public String toString() {
        return this.paramName;
    }
}

