/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.configuration.rate;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.jans.as.model.configuration.rate.KeySource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class KeyExtractor {
    private KeySource source;
    private List<String> parameterNames = new ArrayList<String>();

    public KeyExtractor() {
    }

    @JsonCreator
    public KeyExtractor(@JsonProperty(value="source") KeySource source, @JsonProperty(value="parameterNames") List<String> parameterNames) {
        this.setSource(source);
        this.setParameterNames(parameterNames);
    }

    @JsonProperty(value="source")
    public KeySource getSource() {
        return this.source;
    }

    @JsonProperty(value="source")
    public void setSource(KeySource source) {
        this.source = source;
    }

    @JsonProperty(value="parameterNames")
    public List<String> getParameterNames() {
        return this.parameterNames == null ? Collections.emptyList() : Collections.unmodifiableList(this.parameterNames);
    }

    @JsonProperty(value="parameterNames")
    public void setParameterNames(List<String> parameterNames) {
        ArrayList<String> safe = new ArrayList<String>();
        if (parameterNames != null) {
            for (String p : parameterNames) {
                String v;
                if (p == null || (v = p.trim()).isEmpty()) continue;
                safe.add(v);
            }
        }
        this.parameterNames = safe;
    }

    public boolean isWellFormed() {
        return this.source != null && !this.getParameterNames().isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KeyExtractor)) {
            return false;
        }
        KeyExtractor that = (KeyExtractor)o;
        return this.source == that.source && Objects.equals(this.getParameterNames(), that.getParameterNames());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.source, this.getParameterNames()});
    }

    public String toString() {
        return "KeyExtractor{source=" + this.source + ", parameterNames=" + this.getParameterNames() + "}";
    }
}

