/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.configuration.rate;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.jans.as.model.configuration.rate.KeyExtractor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class RateLimitRule {
    private String path;
    private List<String> methods = new ArrayList<String>();
    private Integer requestCount;
    private Integer periodInSeconds;
    private List<KeyExtractor> keyExtractors = new ArrayList<KeyExtractor>();

    public RateLimitRule() {
    }

    @JsonCreator
    public RateLimitRule(@JsonProperty(value="path") String path, @JsonProperty(value="methods") List<String> methods, @JsonProperty(value="requestCount") Integer requestCount, @JsonProperty(value="periodInSeconds") Integer periodInSeconds, @JsonProperty(value="keyExtractors") List<KeyExtractor> keyExtractors) {
        this.setPath(path);
        this.setMethods(methods);
        this.setRequestCount(requestCount);
        this.setPeriodInSeconds(periodInSeconds);
        this.setKeyExtractors(keyExtractors);
    }

    @JsonProperty(value="path")
    public String getPath() {
        return this.path;
    }

    @JsonProperty(value="path")
    public void setPath(String path) {
        this.path = path == null || path.trim().isEmpty() ? null : path.trim();
    }

    @JsonProperty(value="methods")
    public List<String> getMethods() {
        return this.methods == null ? Collections.emptyList() : Collections.unmodifiableList(this.methods);
    }

    @JsonProperty(value="methods")
    public void setMethods(List<String> methods) {
        ArrayList<String> safe = new ArrayList<String>();
        if (methods != null) {
            for (String m : methods) {
                String v;
                if (m == null || (v = m.trim()).isEmpty()) continue;
                safe.add(v.toUpperCase());
            }
        }
        this.methods = safe;
    }

    @JsonProperty(value="requestCount")
    public Integer getRequestCount() {
        return this.requestCount;
    }

    @JsonProperty(value="requestCount")
    public void setRequestCount(Integer requestCount) {
        this.requestCount = requestCount != null && requestCount > 0 ? requestCount : null;
    }

    @JsonProperty(value="periodInSeconds")
    public Integer getPeriodInSeconds() {
        return this.periodInSeconds;
    }

    @JsonProperty(value="periodInSeconds")
    public void setPeriodInSeconds(Integer periodInSeconds) {
        this.periodInSeconds = periodInSeconds != null && periodInSeconds > 0 ? periodInSeconds : null;
    }

    @JsonProperty(value="keyExtractors")
    public List<KeyExtractor> getKeyExtractors() {
        return this.keyExtractors == null ? Collections.emptyList() : Collections.unmodifiableList(this.keyExtractors);
    }

    @JsonProperty(value="keyExtractors")
    public void setKeyExtractors(List<KeyExtractor> keyExtractors) {
        ArrayList<KeyExtractor> safe = new ArrayList<KeyExtractor>();
        if (keyExtractors != null) {
            for (KeyExtractor ke : keyExtractors) {
                if (ke == null) continue;
                safe.add(ke);
            }
        }
        this.keyExtractors = safe;
    }

    public boolean isWellFormed() {
        return this.path != null && !this.getMethods().isEmpty() && this.requestCount != null && this.periodInSeconds != null && !this.getKeyExtractors().isEmpty() && this.getKeyExtractors().stream().allMatch(KeyExtractor::isWellFormed);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RateLimitRule)) {
            return false;
        }
        RateLimitRule that = (RateLimitRule)o;
        return Objects.equals(this.path, that.path) && Objects.equals(this.getMethods(), that.getMethods()) && Objects.equals(this.requestCount, that.requestCount) && Objects.equals(this.periodInSeconds, that.periodInSeconds) && Objects.equals(this.getKeyExtractors(), that.getKeyExtractors());
    }

    public int hashCode() {
        return Objects.hash(this.path, this.getMethods(), this.requestCount, this.periodInSeconds, this.getKeyExtractors());
    }

    public String toString() {
        return "RateLimitRule{path='" + this.path + "', methods=" + this.getMethods() + ", requestCount=" + this.requestCount + ", periodInSeconds=" + this.periodInSeconds + ", keyExtractors=" + this.getKeyExtractors() + "}";
    }
}

