/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.crypto.binding;

import com.google.common.base.Function;
import io.jans.as.model.crypto.binding.TokenBinding;
import io.jans.as.model.crypto.binding.TokenBindingMessageParser;
import io.jans.as.model.crypto.binding.TokenBindingParseException;
import io.jans.as.model.crypto.binding.TokenBindingType;
import io.jans.as.model.token.JsonWebResponse;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class TokenBindingMessage {
    private static final Logger log = Logger.getLogger(TokenBindingMessage.class);
    private final List<TokenBinding> tokenBindings;

    public TokenBindingMessage(String base64urlencoded) throws TokenBindingParseException {
        this(TokenBindingMessageParser.parseBase64UrlEncoded(base64urlencoded));
    }

    public TokenBindingMessage(byte[] raw) throws TokenBindingParseException {
        this(TokenBindingMessageParser.parseBytes(raw));
    }

    public TokenBindingMessage(List<TokenBinding> tokenBindings) {
        this.tokenBindings = tokenBindings;
    }

    public List<TokenBinding> getTokenBindings() {
        return this.tokenBindings;
    }

    public TokenBinding getFirstTokenBindingByType(TokenBindingType type) {
        for (TokenBinding binding : this.tokenBindings) {
            if (binding.getTokenBindingType() != type) continue;
            return binding;
        }
        return null;
    }

    public static Function<JsonWebResponse, Void> createIdTokenTokingBindingPreprocessing(String tokenBindingMessageAsString, String rpTokenBindingMessageHashClaimKey) throws TokenBindingParseException {
        boolean tokenBindingMessagePresent = StringUtils.isNotBlank((CharSequence)tokenBindingMessageAsString);
        boolean rpKeyPresent = StringUtils.isNotBlank((CharSequence)rpTokenBindingMessageHashClaimKey);
        log.trace((Object)("TokenBindingMessage present: " + tokenBindingMessagePresent + ", rpCnfKey: " + rpTokenBindingMessageHashClaimKey));
        if (tokenBindingMessagePresent && rpKeyPresent) {
            TokenBindingMessage message = new TokenBindingMessage(tokenBindingMessageAsString);
            TokenBinding referredBinding = message.getFirstTokenBindingByType(TokenBindingType.REFERRED_TOKEN_BINDING);
            return jsonWebResponse -> {
                TokenBindingMessage.setCnfClaim(jsonWebResponse, referredBinding.getTokenBindingID().sha256base64url(), rpTokenBindingMessageHashClaimKey);
                return null;
            };
        }
        return null;
    }

    public static void setCnfClaim(JsonWebResponse jsonWebResponse, String tokenBindingIdHash, String rpTokenBindingMessageHashClaimKey) {
        try {
            JSONObject value = jsonWebResponse.getClaims().getClaimAsJSON("cnf");
            if (value == null) {
                value = new JSONObject();
            }
            value.put(rpTokenBindingMessageHashClaimKey, (Object)tokenBindingIdHash);
            jsonWebResponse.getClaims().setClaim("cnf", value);
        }
        catch (JSONException e) {
            log.error((Object)"Failed to create cnf JSON object", (Throwable)e);
        }
    }

    public static String getTokenBindingIdHashFromTokenBindingMessage(String tokenBindingMessageAsString, String rpTokenBindingMessageHashClaimKey) throws TokenBindingParseException {
        if (StringUtils.isNotBlank((CharSequence)tokenBindingMessageAsString) && StringUtils.isNotBlank((CharSequence)rpTokenBindingMessageHashClaimKey)) {
            TokenBindingMessage message = new TokenBindingMessage(tokenBindingMessageAsString);
            TokenBinding referredBinding = message.getFirstTokenBindingByType(TokenBindingType.REFERRED_TOKEN_BINDING);
            return referredBinding.getTokenBindingID().sha256base64url();
        }
        return null;
    }

    public String toString() {
        return "TokenBindingMessage{tokenBindings=" + this.tokenBindings + "}";
    }
}

