/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.crypto.signature;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.jans.as.model.jwk.KeyType;

public enum AlgorithmFamily {
    NONE("none", null),
    HMAC("HMAC", KeyType.OCT),
    RSA("RSA", KeyType.RSA),
    EC("EC", KeyType.EC),
    ED("ED", KeyType.OKP),
    AES("AES", KeyType.OCT),
    PASSW("PASSW", KeyType.OCT),
    DIR("DIR", null);

    private final String value;
    private final KeyType keyType;

    private AlgorithmFamily(String value, KeyType keyType) {
        this.value = value;
        this.keyType = keyType;
    }

    public String getValue() {
        return this.value;
    }

    public KeyType getKeyType() {
        return this.keyType;
    }

    @JsonValue
    public String toString() {
        return this.value;
    }

    @JsonCreator
    public static AlgorithmFamily fromString(String param) {
        if (param != null) {
            for (AlgorithmFamily gt : AlgorithmFamily.values()) {
                if (!param.equals(gt.value)) continue;
                return gt;
            }
        }
        return null;
    }
}

