/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.crypto.signature;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.jans.as.model.common.HasParamName;
import io.jans.as.model.crypto.signature.AlgorithmFamily;
import io.jans.as.model.crypto.signature.EllipticEdvardsCurve;
import io.jans.as.model.jwt.JwtType;
import io.jans.orm.annotation.AttributeEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum AsymmetricSignatureAlgorithm implements HasParamName,
AttributeEnum
{
    RS256("RS256", AlgorithmFamily.RSA, "SHA256WITHRSA"),
    RS384("RS384", AlgorithmFamily.RSA, "SHA384WITHRSA"),
    RS512("RS512", AlgorithmFamily.RSA, "SHA512WITHRSA"),
    ES256("ES256", AlgorithmFamily.EC, "SHA256WITHECDSA", EllipticEdvardsCurve.P_256),
    ES384("ES384", AlgorithmFamily.EC, "SHA384WITHECDSA", EllipticEdvardsCurve.P_384),
    ES512("ES512", AlgorithmFamily.EC, "SHA512WITHECDSA", EllipticEdvardsCurve.P_521),
    PS256("PS256", AlgorithmFamily.RSA, "SHA256withRSAandMGF1"),
    PS384("PS384", AlgorithmFamily.RSA, "SHA384withRSAandMGF1"),
    PS512("PS512", AlgorithmFamily.RSA, "SHA512withRSAandMGF1");

    private final String name;
    private final AlgorithmFamily family;
    private final String algorithm;
    private final EllipticEdvardsCurve curve;
    private final JwtType jwtType;
    private static final Map<String, AsymmetricSignatureAlgorithm> mapByValues;

    private AsymmetricSignatureAlgorithm(String name, AlgorithmFamily family, String algorithm, EllipticEdvardsCurve curve) {
        this.name = name;
        this.family = family;
        this.algorithm = algorithm;
        this.curve = curve;
        this.jwtType = JwtType.JWT;
    }

    private AsymmetricSignatureAlgorithm(String name, AlgorithmFamily family, String algorithm) {
        this(name, family, algorithm, null);
    }

    @Override
    public String getParamName() {
        return this.name;
    }

    public String getValue() {
        return this.name;
    }

    public AlgorithmFamily getFamily() {
        return this.family;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public EllipticEdvardsCurve getCurve() {
        return this.curve;
    }

    public JwtType getJwtType() {
        return this.jwtType;
    }

    public static List<AsymmetricSignatureAlgorithm> fromString(String[] params) {
        ArrayList<AsymmetricSignatureAlgorithm> asymmetricSignatureAlgorithms = new ArrayList<AsymmetricSignatureAlgorithm>();
        for (String param : params) {
            AsymmetricSignatureAlgorithm asymmetricSignatureAlgorithm = AsymmetricSignatureAlgorithm.fromString(param);
            if (asymmetricSignatureAlgorithm == null) continue;
            asymmetricSignatureAlgorithms.add(asymmetricSignatureAlgorithm);
        }
        return asymmetricSignatureAlgorithms;
    }

    @JsonCreator
    public static AsymmetricSignatureAlgorithm fromString(String param) {
        if (param != null) {
            for (AsymmetricSignatureAlgorithm sa : AsymmetricSignatureAlgorithm.values()) {
                if (!param.equals(sa.name)) continue;
                return sa;
            }
        }
        return null;
    }

    public static AsymmetricSignatureAlgorithm getByValue(String value) {
        return mapByValues.get(value);
    }

    public Enum<? extends AttributeEnum> resolveByValue(String value) {
        return AsymmetricSignatureAlgorithm.getByValue(value);
    }

    @JsonValue
    public String toString() {
        return this.name;
    }

    static {
        mapByValues = new HashMap<String, AsymmetricSignatureAlgorithm>();
        for (AsymmetricSignatureAlgorithm enumType : AsymmetricSignatureAlgorithm.values()) {
            mapByValues.put(enumType.getValue(), enumType);
        }
    }
}

