/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.crypto.signature;

import io.jans.as.model.crypto.PrivateKey;
import io.jans.as.model.crypto.signature.SignatureAlgorithm;
import io.jans.as.model.util.Base64Util;
import java.io.IOException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.json.JSONException;
import org.json.JSONObject;

public class EDDSAPrivateKey
extends PrivateKey {
    private final byte[] dEncoded;
    private final byte[] xEncoded;

    public EDDSAPrivateKey(SignatureAlgorithm signatureAlgorithm, byte[] dEncoded, byte[] xEncoded) {
        this.setSignatureAlgorithm(signatureAlgorithm);
        this.dEncoded = (byte[])dEncoded.clone();
        this.xEncoded = (byte[])xEncoded.clone();
    }

    public EDDSAPrivateKey(EDDSAPrivateKey eddsaPrivateKey) {
        this.setSignatureAlgorithm(eddsaPrivateKey.getSignatureAlgorithm());
        byte[] inDEncoded = eddsaPrivateKey.getPrivateKeyEncoded();
        byte[] inXEncoded = eddsaPrivateKey.getPublicKeyEncoded();
        this.dEncoded = inDEncoded != null ? (byte[])inDEncoded.clone() : null;
        this.xEncoded = inXEncoded != null ? (byte[])inXEncoded.clone() : null;
        this.setKeyId(eddsaPrivateKey.getKeyId());
    }

    public PKCS8EncodedKeySpec getPrivateKeySpec() {
        return new PKCS8EncodedKeySpec(this.dEncoded);
    }

    public X509EncodedKeySpec getPublicKeySpec() {
        if (this.xEncoded == null) {
            return null;
        }
        return new X509EncodedKeySpec(this.xEncoded);
    }

    public byte[] getPrivateKeyDecoded() throws IOException {
        PrivateKeyInfo pki = PrivateKeyInfo.getInstance((Object)new PKCS8EncodedKeySpec(this.dEncoded).getEncoded());
        return ASN1OctetString.getInstance((Object)pki.parsePrivateKey()).getOctets();
    }

    public byte[] getPrivateKeyEncoded() {
        return this.dEncoded != null ? this.dEncoded : new byte[]{};
    }

    public byte[] getPublicKeyDecoded() {
        if (this.xEncoded == null) {
            return new byte[0];
        }
        SubjectPublicKeyInfo subjPubKeyInfo = SubjectPublicKeyInfo.getInstance((Object)this.xEncoded);
        return subjPubKeyInfo.getPublicKeyData().getOctets();
    }

    public byte[] getPublicKeyEncoded() {
        return this.xEncoded;
    }

    @Override
    public JSONObject toJSONObject() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("n", JSONObject.NULL);
        jsonObject.put("e", JSONObject.NULL);
        jsonObject.put("d", (Object)Base64Util.base64urlencode(this.dEncoded));
        jsonObject.put("x", (Object)Base64Util.base64urlencode(this.xEncoded));
        return jsonObject;
    }

    public String toString() {
        try {
            return this.toJSONObject().toString(4);
        }
        catch (Exception e) {
            return "";
        }
    }
}

