/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.jwk;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.nimbusds.jose.jwk.JWKException;
import io.jans.as.model.crypto.signature.EllipticEdvardsCurve;
import io.jans.as.model.jwk.Algorithm;
import io.jans.as.model.jwk.KeyOpsType;
import io.jans.as.model.jwk.KeyType;
import io.jans.as.model.jwk.Use;
import io.jans.as.model.util.Base64Util;
import io.jans.as.model.util.JwtUtil;
import io.jans.as.model.util.StringUtils;
import io.jans.as.model.util.Util;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONWebKey {
    private static final String KTY_PARAM_APPEND = "\"kty\":";
    private static final String CRV_PARAM_APPEND = "\"crv\":";
    private static final String N_PARAM_APPEND = "\"n\":";
    private static final String E_PARAM_APPEND = "\"e\":";
    private static final String X_PARAM_APPEND = "\"x\":";
    private static final String Y_PARAM_APPEND = "\"y\":";
    private String name;
    private String descr;
    private String kid;
    private KeyType kty;
    private Use use;
    private Algorithm alg;
    private Long exp;
    private EllipticEdvardsCurve crv;
    private List<String> x5c;
    @JsonProperty(value="key_ops_type")
    private List<KeyOpsType> keyOpsType;
    private String n;
    private String e;
    private String x;
    private String y;

    public List<KeyOpsType> getKeyOpsType() {
        return this.keyOpsType;
    }

    public void setKeyOpsType(List<KeyOpsType> keyOpsType) {
        this.keyOpsType = keyOpsType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescr() {
        return this.descr;
    }

    public void setDescr(String description) {
        this.descr = description;
    }

    public String getKid() {
        return this.kid;
    }

    public void setKid(String kid) {
        this.kid = kid;
    }

    public KeyType getKty() {
        return this.kty;
    }

    public void setKty(KeyType kty) {
        this.kty = kty;
    }

    public Use getUse() {
        return this.use;
    }

    public void setUse(Use use) {
        this.use = use;
    }

    public Algorithm getAlg() {
        return this.alg;
    }

    public void setAlg(Algorithm alg) {
        this.alg = alg;
    }

    public Long getExp() {
        return this.exp;
    }

    public void setExp(Long exp) {
        this.exp = exp;
    }

    public EllipticEdvardsCurve getCrv() {
        return this.crv;
    }

    public void setCrv(EllipticEdvardsCurve crv) {
        this.crv = crv;
    }

    public List<String> getX5c() {
        return this.x5c;
    }

    public void setX5c(List<String> x5c) {
        this.x5c = x5c;
    }

    public String getN() {
        return this.n;
    }

    public void setN(String n) {
        this.n = n;
    }

    public String getE() {
        return this.e;
    }

    public void setE(String e) {
        this.e = e;
    }

    public String getX() {
        return this.x;
    }

    public void setX(String x) {
        this.x = x;
    }

    public String getY() {
        return this.y;
    }

    public void setY(String y) {
        this.y = y;
    }

    @JsonIgnore
    public String getJwkThumbprint() throws NoSuchAlgorithmException, NoSuchProviderException, JWKException {
        String result;
        if (this.kty == null) {
            throw new JWKException("The kty param is required");
        }
        if (this.kty == KeyType.RSA) {
            result = this.contructJwkRSA();
        } else if (this.kty == KeyType.EC) {
            result = this.contructJwkEC();
        } else if (this.kty == KeyType.OKP) {
            result = this.contructJwkOKP();
        } else {
            throw new JWKException("Thumbprint not supported for the kty");
        }
        return result;
    }

    private String contructJwkRSA() throws NoSuchAlgorithmException, NoSuchProviderException, JWKException {
        if (this.e == null) {
            throw new JWKException("The e param is required");
        }
        if (this.n == null) {
            throw new JWKException("The n param is required");
        }
        String jwkStr = "{" + E_PARAM_APPEND + "\"" + this.e + "\"," + KTY_PARAM_APPEND + "\"" + (Object)((Object)this.kty) + "\"," + N_PARAM_APPEND + "\"" + this.n + "\"" + "}";
        byte[] hash = JwtUtil.getMessageDigestSHA256(jwkStr);
        return Base64Util.base64urlencode(hash);
    }

    private String contructJwkEC() throws NoSuchAlgorithmException, NoSuchProviderException, JWKException {
        if (this.crv == null) {
            throw new JWKException("The crv is required");
        }
        if (this.x == null) {
            throw new JWKException("The x is required");
        }
        if (this.y == null) {
            throw new JWKException("The y is required");
        }
        String jwkStr = "{" + CRV_PARAM_APPEND + "\"" + (Object)((Object)this.crv) + "\"," + KTY_PARAM_APPEND + "\"" + (Object)((Object)this.kty) + "\"," + X_PARAM_APPEND + "\"" + this.x + "\"," + Y_PARAM_APPEND + "\"" + this.y + "\"" + "}";
        byte[] hash = JwtUtil.getMessageDigestSHA256(jwkStr);
        return Base64Util.base64urlencode(hash);
    }

    private String contructJwkOKP() throws NoSuchAlgorithmException, NoSuchProviderException, JWKException {
        if (this.crv == null) {
            throw new JWKException("The crv is required");
        }
        if (this.x == null) {
            throw new JWKException("The x is required");
        }
        String jwkStr = "{" + CRV_PARAM_APPEND + "\"" + (Object)((Object)this.crv) + "\"," + KTY_PARAM_APPEND + "\"" + (Object)((Object)this.kty) + "\"," + X_PARAM_APPEND + "\"" + this.y + "\"" + "}";
        byte[] hash = JwtUtil.getMessageDigestSHA256(jwkStr);
        return Base64Util.base64urlencode(hash);
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jsonObj = new JSONObject();
        if (this.name != null) {
            jsonObj.put("name", (Object)this.name);
        }
        if (this.descr != null) {
            jsonObj.put("descr", (Object)this.descr);
        }
        jsonObj.put("kid", (Object)this.kid);
        jsonObj.put("kty", (Object)this.kty);
        if (this.use != null) {
            jsonObj.put("use", (Object)this.use.getParamName());
        }
        JSONArray keyOpsTypeArray = new JSONArray();
        if (this.keyOpsType != null) {
            for (KeyOpsType keyOpType : this.keyOpsType) {
                keyOpsTypeArray.put((Object)keyOpType.getValue());
            }
        }
        jsonObj.put("key_ops_type", (Object)keyOpsTypeArray);
        jsonObj.put("alg", (Object)this.alg);
        jsonObj.put("exp", (Object)this.exp);
        if (this.crv != null) {
            jsonObj.put("crv", (Object)this.crv.getName());
        }
        if (!Util.isNullOrEmpty(this.n)) {
            jsonObj.put("n", (Object)this.n);
        }
        if (!Util.isNullOrEmpty(this.e)) {
            jsonObj.put("e", (Object)this.e);
        }
        if (!Util.isNullOrEmpty(this.x)) {
            jsonObj.put("x", (Object)this.x);
        }
        if (!Util.isNullOrEmpty(this.y)) {
            jsonObj.put("y", (Object)this.y);
        }
        if (this.x5c != null && !this.x5c.isEmpty()) {
            jsonObj.put("x5c", (Object)StringUtils.toJSONArray(this.x5c));
        }
        return jsonObj;
    }

    public static JSONWebKey fromJSONObject(JSONObject jwkJSONObject) throws JSONException {
        JSONWebKey jwk = new JSONWebKey();
        jwk.setName(jwkJSONObject.optString("name"));
        jwk.setDescr(jwkJSONObject.optString("descr"));
        jwk.setKid(jwkJSONObject.optString("kid"));
        jwk.setKty(KeyType.fromString(jwkJSONObject.optString("kty")));
        jwk.setUse(Use.fromString(jwkJSONObject.optString("use")));
        jwk.setAlg(Algorithm.fromString(jwkJSONObject.optString("alg")));
        jwk.setKeyOpsType(KeyOpsType.fromJSONArray(jwkJSONObject.optJSONArray("key_ops_type")));
        if (jwkJSONObject.has("exp")) {
            jwk.setExp(jwkJSONObject.optLong("exp"));
        }
        jwk.setCrv(EllipticEdvardsCurve.fromString(jwkJSONObject.optString("crv")));
        if (jwkJSONObject.has("n")) {
            jwk.setN(jwkJSONObject.optString("n"));
        }
        if (jwkJSONObject.has("e")) {
            jwk.setE(jwkJSONObject.optString("e"));
        }
        if (jwkJSONObject.has("x")) {
            jwk.setX(jwkJSONObject.optString("x"));
        }
        if (jwkJSONObject.has("y")) {
            jwk.setY(jwkJSONObject.optString("y"));
        }
        if (jwkJSONObject.has("x5c")) {
            jwk.setX5c(StringUtils.toList(jwkJSONObject.optJSONArray("x5c")));
        }
        return jwk;
    }
}

