/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.jws;

import io.jans.as.model.crypto.Certificate;
import io.jans.as.model.crypto.signature.AlgorithmFamily;
import io.jans.as.model.crypto.signature.EDDSAPrivateKey;
import io.jans.as.model.crypto.signature.EDDSAPublicKey;
import io.jans.as.model.crypto.signature.SignatureAlgorithm;
import io.jans.as.model.jws.AbstractJwsSigner;
import io.jans.as.model.util.Base64Util;
import io.jans.util.security.SecurityProviderUtility;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.bouncycastle.jcajce.provider.asymmetric.edec.BCEdDSAPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.edec.BCEdDSAPublicKey;

public class EDDSASigner
extends AbstractJwsSigner {
    private EDDSAPrivateKey eddsaPrivateKey;
    private EDDSAPublicKey eddsaPublicKey;

    public EDDSASigner(SignatureAlgorithm signatureAlgorithm, EDDSAPrivateKey eddsaPrivateKey) {
        super(signatureAlgorithm);
        this.eddsaPrivateKey = eddsaPrivateKey;
    }

    public EDDSASigner(SignatureAlgorithm signatureAlgorithm, EDDSAPublicKey eddsaPublicKey) {
        super(signatureAlgorithm);
        this.eddsaPublicKey = eddsaPublicKey;
    }

    public EDDSASigner(SignatureAlgorithm signatureAlgorithm, Certificate certificate) {
        super(signatureAlgorithm);
        this.eddsaPublicKey = certificate.getEddsaPublicKey();
    }

    @Override
    public String generateSignature(String signingInput) throws SignatureException {
        if (!SecurityProviderUtility.isBcProvMode()) {
            throw new InvalidParameterException("Wrong CryptoProvider Mode. EdDSA can be used, when BCPROV mode is initialized");
        }
        SignatureAlgorithm signatureAlgorithm = this.getSignatureAlgorithm();
        if (signatureAlgorithm == null) {
            throw new SignatureException("The signature algorithm is null");
        }
        if (!signatureAlgorithm.getFamily().equals((Object)AlgorithmFamily.ED)) {
            throw new SignatureException(String.format("Wrong value of the signature algorithm: %s", signatureAlgorithm.getFamily().toString()));
        }
        if (this.eddsaPrivateKey == null) {
            throw new SignatureException("The EDDSA private key is null");
        }
        if (signingInput == null) {
            throw new SignatureException("The signing input is null");
        }
        try {
            PKCS8EncodedKeySpec privateKeySpec = this.eddsaPrivateKey.getPrivateKeySpec();
            KeyFactory keyFactory = KeyFactory.getInstance(signatureAlgorithm.getName());
            BCEdDSAPrivateKey privateKey = (BCEdDSAPrivateKey)keyFactory.generatePrivate(privateKeySpec);
            Signature signer = Signature.getInstance(signatureAlgorithm.getName(), SecurityProviderUtility.getBCProvider());
            signer.initSign((PrivateKey)privateKey);
            signer.update(signingInput.getBytes());
            byte[] signature = signer.sign();
            return Base64Util.base64urlencode(signature);
        }
        catch (IllegalArgumentException | InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new SignatureException(e);
        }
    }

    @Override
    public boolean validateSignature(String signingInput, String signature) throws SignatureException {
        if (!SecurityProviderUtility.isBcProvMode()) {
            throw new InvalidParameterException("Wrong CryptoProvider Mode. EdDSA can be used, when BCPROV mode is initialized");
        }
        SignatureAlgorithm signatureAlgorithm = this.getSignatureAlgorithm();
        if (signatureAlgorithm == null) {
            throw new SignatureException("The signature algorithm is null");
        }
        if (!signatureAlgorithm.getFamily().equals((Object)AlgorithmFamily.ED)) {
            throw new SignatureException(String.format("Wrong value of the signature algorithm: %s", signatureAlgorithm.getFamily().toString()));
        }
        if (this.eddsaPublicKey == null) {
            throw new SignatureException("The EDDSA public key is null");
        }
        if (signingInput == null) {
            throw new SignatureException("The signing input is null");
        }
        try {
            X509EncodedKeySpec publicKeySpec = this.eddsaPublicKey.getPublicKeySpec();
            KeyFactory keyFactory = KeyFactory.getInstance(signatureAlgorithm.getName());
            BCEdDSAPublicKey publicKey = (BCEdDSAPublicKey)keyFactory.generatePublic(publicKeySpec);
            Signature virifier = Signature.getInstance(signatureAlgorithm.getName(), SecurityProviderUtility.getBCProvider());
            virifier.initVerify((PublicKey)publicKey);
            virifier.update(signingInput.getBytes());
            return virifier.verify(Base64Util.base64urldecode(signature));
        }
        catch (IllegalArgumentException | InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new SignatureException(e);
        }
    }
}

