/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.jwt;

import io.jans.as.model.exception.InvalidJwtException;
import io.jans.as.model.jwt.JwtClaims;
import io.jans.as.model.jwt.JwtHeader;
import io.jans.as.model.token.JsonWebResponse;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jwt
extends JsonWebResponse {
    private static final Logger log = LoggerFactory.getLogger(Jwt.class);
    private String encodedHeader = null;
    private String encodedClaims = null;
    private String encodedSignature = null;
    private boolean loaded = false;

    public String getEncodedSignature() {
        return this.encodedSignature;
    }

    public void setEncodedSignature(String encodedSignature) {
        this.encodedSignature = encodedSignature;
    }

    public String getSigningInput() throws InvalidJwtException {
        if (this.loaded) {
            return this.encodedHeader + "." + this.encodedClaims;
        }
        return this.header.toBase64JsonObject() + "." + this.claims.toBase64JsonObject();
    }

    public static Jwt parseOrThrow(String encodedJwt) throws InvalidJwtException {
        return Jwt.parse(encodedJwt);
    }

    public static Jwt parseSilently(String encodedJwt) {
        if (StringUtils.isBlank((CharSequence)encodedJwt)) {
            return null;
        }
        try {
            return Jwt.parse(encodedJwt);
        }
        catch (Exception e) {
            log.trace(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @NotNull
    public static Jwt parse(String encodedJwt) throws InvalidJwtException {
        if (StringUtils.isBlank((CharSequence)encodedJwt)) {
            throw new InvalidJwtException("Jwt is blank.");
        }
        String encodedHeader = null;
        String encodedClaims = null;
        String encodedSignature = null;
        String[] jwtParts = encodedJwt.split("\\.");
        if (jwtParts.length == 2) {
            encodedHeader = jwtParts[0];
            encodedClaims = jwtParts[1];
            encodedSignature = "";
        } else if (jwtParts.length == 3) {
            encodedHeader = jwtParts[0];
            encodedClaims = jwtParts[1];
            encodedSignature = jwtParts[2];
        } else {
            throw new InvalidJwtException("Invalid JWT format.");
        }
        Jwt jwt = new Jwt();
        jwt.setHeader(new JwtHeader(encodedHeader));
        jwt.setClaims(new JwtClaims(encodedClaims));
        jwt.setEncodedSignature(encodedSignature);
        jwt.encodedHeader = encodedHeader;
        jwt.encodedClaims = encodedClaims;
        jwt.loaded = true;
        return jwt;
    }

    @Override
    public String toString() {
        try {
            if (this.encodedSignature == null) {
                return this.getSigningInput() + ".";
            }
            return this.getSigningInput() + "." + this.encodedSignature;
        }
        catch (InvalidJwtException e) {
            e.printStackTrace();
            return "";
        }
    }
}

