/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.token;

import io.jans.as.model.exception.InvalidJwtException;
import io.jans.as.model.jwt.JwtClaims;
import io.jans.as.model.jwt.JwtHeader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonWebResponse
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(JsonWebResponse.class);
    private static final long serialVersionUID = -4141298937204111173L;
    protected JwtHeader header = new JwtHeader();
    protected JwtClaims claims = new JwtClaims();

    public JwtHeader getHeader() {
        return this.header;
    }

    public void setHeader(JwtHeader header) {
        this.header = header;
    }

    public JwtClaims getClaims() {
        return this.claims;
    }

    public void setClaim(String key, String value) {
        if (this.claims == null) {
            return;
        }
        this.claims.setClaim(key, value);
    }

    public void setClaims(JwtClaims claims) {
        this.claims = claims;
    }

    public String asString() {
        try {
            return this.claims.toJsonString();
        }
        catch (InvalidJwtException ex) {
            ex.printStackTrace();
            return "";
        }
    }

    public String toString() {
        return this.asString();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        try {
            oos.writeUTF(this.header.toBase64JsonObject());
            oos.writeUTF(this.claims.toBase64JsonObject());
        }
        catch (InvalidJwtException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException, InvalidJwtException {
        JwtHeader readHeader = new JwtHeader();
        readHeader.load(ois.readUTF());
        this.setHeader(readHeader);
        JwtClaims readClaims = new JwtClaims();
        readClaims.load(ois.readUTF());
        this.setClaims(readClaims);
    }
}

