/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.authorize;

import io.jans.as.model.authorize.CodeVerifier;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CodeVerifierTest {
    private static void assertMatch(CodeVerifier.CodeChallengeMethod type) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        CodeVerifier verifier = new CodeVerifier(type);
        System.out.println(verifier);
        if (type == CodeVerifier.CodeChallengeMethod.PLAIN) {
            Assert.assertEquals((String)verifier.getCodeChallenge(), (String)verifier.getCodeVerifier());
            return;
        }
        MessageDigest md = MessageDigest.getInstance(type.getMessageDigestString());
        md.update(verifier.getCodeVerifier().getBytes(StandardCharsets.UTF_8));
        byte[] digest = md.digest();
        Assert.assertEquals((String)CodeVerifier.base64UrlEncode((byte[])digest), (String)verifier.getCodeChallenge());
    }

    @Test
    public void verifierAndChallengeMatch() throws NoSuchAlgorithmException, UnsupportedEncodingException {
        CodeVerifierTest.assertMatch(CodeVerifier.CodeChallengeMethod.PLAIN);
        CodeVerifierTest.assertMatch(CodeVerifier.CodeChallengeMethod.S256);
        Assert.assertFalse((boolean)CodeVerifier.matched(null, (String)"", (String)"invalid_code"));
    }

    @Test
    public void verify() {
        String codeChallenge = CodeVerifier.generateCodeChallenge((CodeVerifier.CodeChallengeMethod)CodeVerifier.CodeChallengeMethod.S256, (String)"dBjftJeZ4CVP-mB92K27uhbUJU1p1r_wW1gFWFOEjXk");
        Assert.assertEquals((String)codeChallenge, (String)"E9Melhoa2OwvFrEMTJguCHaoeK1t8URWbuGJSstw-cM");
    }

    @Test
    public void codeVerificationGenerator() {
        for (int i = 0; i < 10; ++i) {
            Assert.assertTrue((boolean)CodeVerifier.isCodeVerifierValid((String)CodeVerifier.generateCodeVerifier()));
        }
    }
}

