/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.crypto.binding;

import io.jans.as.model.crypto.binding.TokenBinding;
import io.jans.as.model.crypto.binding.TokenBindingMessage;
import io.jans.as.model.crypto.binding.TokenBindingParseException;
import io.jans.as.model.crypto.binding.TokenBindingType;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TokenBindingParserTest {
    @Test
    public void testParsingAndSHA256hashOfTokenBindingId() throws TokenBindingParseException {
        String encoded = "ARIAAgBBQCfsI1D1sTq5mvT_2H_dihNIvuHJCHGjHPJchPavNbGrOo26-2JgT_IsbvZd4daDFbirYBIwJ-TK1rh8FzrC-psAQO4Au9xPupLSkhwT9Yn9aSvHXFsMLh4d4cEBKGP1clJtsfUFGDw-8HQSKwgKFN3WfZGq27y8NB3NAM1oNzvqVOIAAAECAEFArPIiuZxj9gK0dWhIcG63r2-sZ8V3LX9gpNl8Um_oGOtmwoP1v0VHNIHEOzW3BOqcBLvUzVEG6a6KGEj3GrFcqQBA9YxqHPBIuDui_aQ1SoRGKyBEhaG2i-Wke3erRb1YwC7nTgrpqqJG3z1P8bt7cjZN6TpOyktdSSK7OJgiApwG7AAA";
        String expectedIdHash = "suMuxh_IlrP-Zrj33LuQOQ5rX039cmBe-wt2df3BrUQ";
        TokenBindingMessage message = new TokenBindingMessage(encoded);
        TokenBinding referredBinding = message.getFirstTokenBindingByType(TokenBindingType.REFERRED_TOKEN_BINDING);
        Assert.assertEquals((String)expectedIdHash, (String)referredBinding.getTokenBindingID().sha256base64url());
    }
}

