/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.token;

import io.jans.as.model.BaseTest;
import io.jans.as.model.crypto.signature.SignatureAlgorithm;
import io.jans.as.model.jwt.JwtType;
import io.jans.as.model.token.JsonWebResponse;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Calendar;
import org.testng.Assert;
import org.testng.annotations.Test;

public class JsonWebResponseTest
extends BaseTest {
    @Test
    public void serialization_object_correctSerialization() throws IOException, ClassNotFoundException {
        this.showTitle("serialization_object_correctSerialization");
        JsonWebResponse toWrite = new JsonWebResponse();
        toWrite.getHeader().setAlgorithm(SignatureAlgorithm.RS256);
        toWrite.getHeader().setType(JwtType.JWT);
        Calendar cal = Calendar.getInstance();
        cal.set(14, 0);
        toWrite.getClaims().setExpirationTime(cal.getTime());
        toWrite.getClaims().setClaim("testClaim", Long.valueOf(45L));
        FileOutputStream fileOut = new FileOutputStream("fileJsonWebResponse.ser");
        ObjectOutputStream out = new ObjectOutputStream(fileOut);
        out.writeObject(toWrite);
        out.close();
        fileOut.close();
        JsonWebResponse deserealized = null;
        FileInputStream fileIn = new FileInputStream("fileJsonWebResponse.ser");
        ObjectInputStream in = new ObjectInputStream(fileIn);
        deserealized = (JsonWebResponse)in.readObject();
        in.close();
        fileIn.close();
        Assert.assertEquals((Object)toWrite.getHeader().getSignatureAlgorithm(), (Object)deserealized.getHeader().getSignatureAlgorithm());
        Assert.assertEquals((Object)toWrite.getHeader().getType(), (Object)deserealized.getHeader().getType());
        Assert.assertEquals((Object)toWrite.getClaims().getClaimAsDate("exp"), (Object)deserealized.getClaims().getClaimAsDate("exp"));
        Assert.assertEquals((Long)toWrite.getClaims().getClaimAsLong("testClaim"), (Long)deserealized.getClaims().getClaimAsLong("testClaim"));
    }
}

