/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.util;

import io.jans.as.model.BaseTest;
import io.jans.as.model.util.QueryStringDecoder;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class QueryStringDecoderTest
extends BaseTest {
    @Test
    public void decode_nullParam_emptyMap() {
        this.showTitle("decode_nullParam_emptyMap");
        Map queryParamMap = QueryStringDecoder.decode(null);
        Assert.assertTrue((boolean)queryParamMap.isEmpty());
    }

    @Test
    public void decode_emptyParam_emptyMap() {
        this.showTitle("decode_emptyParam_emptyMap");
        Map queryParamMap = QueryStringDecoder.decode((String)"");
        Assert.assertTrue((boolean)queryParamMap.isEmpty());
    }

    @Test
    public void decode_simpleParam_validParam() {
        this.showTitle("decode_simpleParam_validParam");
        String key1 = "key1";
        String key2 = "key2";
        String simpleValue = "SIMPLE";
        String urlValue = "http://localhost:9000";
        String queryParamString = String.format("%s=%s&%s=%s", key1, simpleValue, key2, urlValue);
        Map queryParamMap = QueryStringDecoder.decode((String)queryParamString);
        Assert.assertEquals((int)queryParamMap.size(), (int)2);
        Assert.assertEquals((String)((String)queryParamMap.get(key1)), (String)simpleValue);
        Assert.assertEquals((String)((String)queryParamMap.get(key2)), (String)urlValue);
    }

    @Test
    public void decode_encodedParam_validParam() {
        this.showTitle("decode_encodedParam_validParam");
        String key1 = "key1";
        String key3 = "key3";
        String urlValue = "http://localhost:9000";
        String encodedUrlValue = "http%3A%2F%2Flocalhost%3A9000";
        String queryParamString = String.format("%s=%s&%s=%s", key1, urlValue, key3, encodedUrlValue);
        Map queryParamMap = QueryStringDecoder.decode((String)queryParamString);
        Assert.assertEquals((int)queryParamMap.size(), (int)2);
        Assert.assertEquals((String)((String)queryParamMap.get(key1)), (String)urlValue);
        Assert.assertEquals((String)((String)queryParamMap.get(key3)), (String)urlValue);
    }

    @Test
    public void decode_emptyKeyAndValueParam_validParam() {
        this.showTitle("decode_emptyKeyAndValueParam_validParam");
        String emptyKey = "";
        String key2 = "key2";
        String simpleValue = "SIMPLE";
        String emptyValue = "";
        String queryParamString = String.format("%s=%s&%s=%s", emptyKey, simpleValue, key2, emptyValue);
        Map queryParamMap = QueryStringDecoder.decode((String)queryParamString);
        Assert.assertEquals((int)queryParamMap.size(), (int)1);
        Assert.assertEquals((String)((String)queryParamMap.get(key2)), (String)emptyValue);
    }

    @Test
    public void decode_unsupportedDecodedParam_validParam() {
        this.showTitle("decode_unsupportedDecodedParam_validParam");
        String key1 = "key1";
        String key2 = "key2";
        String urlValue = "http://localhost:9000";
        String encodedUrlValue = "http%3A%2F%2Flocalhost%3A9000";
        String unsupportedValue = "http%3A%2F%2Flocalhost%3A9000%GG";
        String queryParamString = String.format("%s=%s&%s=%s", key1, encodedUrlValue, key2, unsupportedValue);
        Map queryParamMap = QueryStringDecoder.decode((String)queryParamString);
        Assert.assertEquals((int)queryParamMap.size(), (int)1);
        Assert.assertEquals((String)((String)queryParamMap.get(key1)), (String)urlValue);
    }
}

