/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.util;

import io.jans.as.model.BaseTest;
import io.jans.as.model.common.Prompt;
import io.jans.as.model.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.json.JSONArray;
import org.testng.Assert;
import org.testng.annotations.Test;

public class StringUtilsTest
extends BaseTest {
    @Test
    public void nullToEmpty_nullString_emptyString() {
        this.showTitle("nullToEmpty_nullString_emptyString");
        String result = StringUtils.nullToEmpty(null);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)result, (String)"");
    }

    @Test
    public void equals_bothParamsNull_true() {
        this.showTitle("equals_bothParamsNull_true");
        Assert.assertTrue((boolean)StringUtils.equals(null, null));
    }

    @Test
    public void equals_oneParamNull_false() {
        this.showTitle("equals_oneParamNull_false");
        Assert.assertFalse((boolean)StringUtils.equals((String)"text", null));
    }

    @Test
    public void equals_validParamsDifferents_false() {
        this.showTitle("equals_validParamsDifferents_false");
        Assert.assertFalse((boolean)StringUtils.equals((String)"text", (String)"other_text"));
    }

    @Test
    public void equals_validParamsEquals_true() {
        this.showTitle("equals_validParamsEquals_true");
        Assert.assertTrue((boolean)StringUtils.equals((String)"text", (String)"text"));
    }

    @Test
    public void equalsIgnoringSpaces_nullParams_false() {
        this.showTitle("equalsIgnoringSpaces_nullParams_false");
        Assert.assertFalse((boolean)StringUtils.equalsIgnoringSpaces(null, null));
    }

    @Test
    public void equalsIgnoringSpaces_validParamsEquals_true() {
        this.showTitle("equalsIgnoringSpaces_validParamsEquals_true");
        Assert.assertTrue((boolean)StringUtils.equalsIgnoringSpaces((String)"text test 1", (String)"TextTest1"));
    }

    @Test
    public void implode_inputArrayGlueString_true() {
        this.showTitle("implode_inputArrayGlueString_true");
        String[] inputArray = new String[]{"text", "123", "abc 123", " ", "new"};
        String glueString = "-";
        Assert.assertEquals((String)StringUtils.implode((String[])inputArray, (String)glueString), (String)"text-123-abc 123- -new");
    }

    @Test
    public void implode_collectionGlueString_true() {
        this.showTitle("implode_collectionGlueString_true");
        String[] inputArray = new String[]{"text", "123", "abc 123", " ", "new"};
        List<String> collection = Arrays.asList(inputArray);
        String glueString = "-";
        Assert.assertEquals((String)StringUtils.implode(collection, (String)glueString), (String)"text-123-abc 123- -new");
    }

    @Test
    public void implodeEnum_listPromtGlueString_true() {
        this.showTitle("implodeEnum_listPromtGlueString_true");
        ArrayList<Prompt> lisEnumsPrompts = new ArrayList<Prompt>();
        lisEnumsPrompts.add(Prompt.LOGIN);
        lisEnumsPrompts.add(Prompt.SELECT_ACCOUNT);
        lisEnumsPrompts.add(Prompt.CONSENT);
        String glueString = "-";
        Assert.assertEquals((String)StringUtils.implodeEnum(lisEnumsPrompts, (String)glueString), (String)"login-select_account-consent");
    }

    @Test
    public void spaceSeparatedToList_stringWithSpaces_listSeparatedBySpace() {
        this.showTitle("spaceSeparatedToList_stringWithSpaces_listSeparatedBySpace");
        String spaceSeparatedString = "Hello World, this is a test";
        ArrayList<String> expectedResult = new ArrayList<String>();
        expectedResult.add("Hello");
        expectedResult.add("World,");
        expectedResult.add("this");
        expectedResult.add("is");
        expectedResult.add("a");
        expectedResult.add("test");
        Assert.assertEquals((Collection)StringUtils.spaceSeparatedToList((String)spaceSeparatedString), expectedResult);
    }

    @Test
    public void toJSONArray_listString_jsonArrayOfString() {
        this.showTitle("toJSONArray_listString_jsonArrayOfString");
        ArrayList<String> inputList = new ArrayList<String>();
        inputList.add("Hello");
        inputList.add("World");
        inputList.add("this");
        inputList.add("is");
        inputList.add("a");
        inputList.add("test");
        JSONArray arrayResult = StringUtils.toJSONArray(inputList);
        Assert.assertNotNull((Object)arrayResult);
        Assert.assertTrue((arrayResult.length() == 6 ? 1 : 0) != 0);
        Assert.assertEquals((String)arrayResult.getString(0), (String)"Hello");
        Assert.assertEquals((String)arrayResult.getString(1), (String)"World");
        Assert.assertEquals((String)arrayResult.getString(5), (String)"test");
    }

    @Test
    public void toList_jsonArray_listOfString() {
        this.showTitle("toList_jsonArray_listOfString");
        JSONArray inputJsonArray = new JSONArray();
        inputJsonArray.put((Object)"Hello");
        inputJsonArray.put((Object)"World");
        inputJsonArray.put((Object)"this");
        inputJsonArray.put((Object)"is");
        inputJsonArray.put((Object)"a");
        inputJsonArray.put((Object)"test");
        List listResult = StringUtils.toList((JSONArray)inputJsonArray);
        Assert.assertNotNull((Object)listResult);
        Assert.assertTrue((listResult.size() == 6 ? 1 : 0) != 0);
        Assert.assertEquals((String)((String)listResult.get(0)), (String)"Hello");
        Assert.assertEquals((String)((String)listResult.get(1)), (String)"World");
        Assert.assertEquals((String)((String)listResult.get(5)), (String)"test");
    }

    @Test
    public void parseSilently_stringDate_dateParsed() {
        this.showTitle("parseSilently_stringDate_dateParsed");
        Calendar calendar = Calendar.getInstance();
        calendar.set(14, 0);
        Date testDate = calendar.getTime();
        String inputStringDate = new SimpleDateFormat("EEE MMM d HH:mm:ss zzz yyyy").format(testDate);
        Date resultDate = StringUtils.parseSilently((String)inputStringDate);
        Assert.assertNotNull((Object)resultDate);
        Assert.assertEquals((Object)resultDate, (Object)testDate);
    }

    @Test
    public void addQueryStringParam_validKeyAndValue_stringBuilderWithNewValues() throws UnsupportedEncodingException {
        this.showTitle("addQueryStringParam_validKeyAndValue_stringBuilderWithNewValues");
        StringBuilder queryStringBuilder = new StringBuilder();
        String key = "key0";
        String value = "value0";
        StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)key, (Object)value);
        Assert.assertEquals((int)queryStringBuilder.length(), (int)11);
        Assert.assertEquals((String)queryStringBuilder.toString(), (String)"key0=value0");
    }

    @Test
    public void addQueryStringParam_validKeyAndCollectionValues_stringBuilderWithNewValues() throws UnsupportedEncodingException {
        this.showTitle("addQueryStringParam_validKeyAndCollectionValues_stringBuilderWithNewValues");
        StringBuilder queryStringBuilder = new StringBuilder();
        String key = "key0";
        ArrayList<String> collectionValues = new ArrayList<String>();
        collectionValues.add("value0");
        collectionValues.add("value1");
        collectionValues.add("value2");
        StringUtils.addQueryStringParam((StringBuilder)queryStringBuilder, (String)key, collectionValues);
        Assert.assertEquals((int)queryStringBuilder.length(), (int)37);
        Assert.assertEquals((String)queryStringBuilder.toString(), (String)"key0=%5Bvalue0%2C+value1%2C+value2%5D");
    }

    @Test
    public void generateRandomReadableCode_length12_stringCodeSeparatedByDashes() {
        this.showTitle("generateRandomReadableCode_length12_stringCodeSeparatedByDashes");
        byte length = 12;
        String codeGenerated = StringUtils.generateRandomReadableCode((byte)length);
        Assert.assertNotNull((Object)codeGenerated);
        Assert.assertEquals((int)codeGenerated.replaceAll("-", "").length(), (int)length);
    }

    @Test
    public void generateRandomCode_length8Seed_stringCode() {
        this.showTitle("generateRandomCode_length8Seed_stringCode");
        byte seedLength = 8;
        String codeGenerated = StringUtils.generateRandomCode((byte)seedLength);
        Assert.assertNotNull((Object)codeGenerated);
        Assert.assertEquals((int)codeGenerated.length(), (int)(seedLength * 2));
    }

    @Test
    public void base64urlencode_validStringToEncode_encodedString() {
        this.showTitle("base64urlencode_validStringToEncode_encodedString");
        String input = "Hello world, this is a test.";
        String encodedResult = StringUtils.base64urlencode((String)input);
        Assert.assertNotNull((Object)encodedResult);
        Assert.assertEquals((String)encodedResult, (String)"SGVsbG8gd29ybGQsIHRoaXMgaXMgYSB0ZXN0Lg");
    }
}

